package Freenet.client;

import Freenet.support.Bucket;
import java.net.MalformedURLException;

/** Represents a DataRequest.
  * @author tavin
  */
public class DataRequest extends Request {

    int htl;
    FreenetURI uri;
    Bucket meta, data;

    /** Prepares a request for data described by a Freenet key.
      * @param htl   The HopsToLive to give the request.
      * @param uri   The URI to request.
      * @param meta  A bucket to place the metadata in (if there is any)
      * @param data  A bucket to place the data in
      * @throws MalformedURLException  if the URI string is bad
      */
    public DataRequest(int htl, String uri, Bucket meta, Bucket data)
        throws MalformedURLException
    {
        this(htl, new FreenetURI(uri), meta, data);
    }

    /** Prepares a request for data described by a Freenet key.
      * @param htl   The HopsToLive to give the request.
      * @param uri   The URI to request.
      * @param meta  A bucket to place the metadata in (if there is any)
      * @param data  A bucket to place the data in
      */
    public DataRequest(int htl, FreenetURI uri, Bucket meta, Bucket data) {
        super();
        this.htl  = htl;
        this.uri  = uri;
        this.meta = meta;
        this.data = data;
    }
}
