package Freenet.client;
import Freenet.client.events.*;
import java.io.*;

/**
 * An inputstream that generates status events.
 *
 * @author oskar
 **/

public class EventInputStream extends FilterInputStream 
    implements ClientEventProducer {

    private SimpleEventProducer sep;
    private long interval;
    private long read;

    /**
     * Wrap an EventInputStream around an InputStream.
     * @param in  The Inputstream to read.
     * @param interval  Generate an event every time <b>interval</b> 
     *                  bytes have been moved. 
     **/
    public EventInputStream(InputStream in, long interval) {
	super(in);
	sep = new SimpleEventProducer();
	this.interval = interval;
    }

    public void addEventListener(ClientEventListener cel) {
	sep.addEventListener(cel);
    }

    public boolean removeEventListener(ClientEventListener cel) {
	return sep.removeEventListener(cel);
    }

    public int read() throws IOException {
	int i = super.read();
	if (i != -1) {
	    read++;
	    if (interval != 0 && read % interval == 0) {
		sep.produceEvent(new TransferedEvent(read));
	    }
	} else
	    sep.produceEvent(new TransferCompletedEvent(read));
	return i;
    }

    public int read(byte[] b, int off, int length) throws IOException {
	int i = super.read(b,off,length); 
	if (i != -1) {
	    read += i;
	    if(interval != 0 && i > (interval - (read % interval))) {
		sep.produceEvent(new TransferedEvent(read));
	    }
	} else
	    sep.produceEvent(new TransferCompletedEvent(read));
	return i;
    }

    public void close() throws IOException {
	sep.produceEvent(new TransferCompletedEvent(read));
	super.close();
    }

}














