package Freenet.client;
import Freenet.*;
import Freenet.crypt.*;
import Freenet.support.*;
import Freenet.support.io.*;
import Freenet.client.events.*;
import java.io.*;
import java.net.MalformedURLException;
import Freenet.keys.SVK;
import java.util.*;

/**
 * Client for dealing with in-Freenet key indices
 *
 * @author <a href=mailto:blanu@uts.cc.utexas.edu>Brandon Wiley</a>
 **/

public class IndexClient extends CLI
{     
  SimplifiedClient sc;
  boolean autoRedirect;
  Logger logger=null;
  Params params;

  static public void main(String[] args) throws Exception
  {
//    Core.logger=new StandardLogger(System.out, 0, 0);
    Core.logger=new SuppressedLogger();
    Params p = new Params(args);
    Core.init(p);
    IndexClient ic=new IndexClient(p, Core.logger);
    String index=p.getParam("insert");
    String filename=p.getParam("file");
    int start=p.getint("start", 0);
    boolean useDate=p.getboolean("useDate", true);
    int future=p.getint("future", 0);
    int past=p.getint("past", 0);
    if((future!=0) && (past!=0))
    {
      System.out.println("Future or past. Make up your mind. You can't have both.");
      return;
    }
    int offset=future*86400;
    if(past!=0)
    {
      offset=past*(-86400);
    }

    if(index!=null && filename!=null)
    {
      ic.insertBucket(index, start, useDate, offset, new FileBucket(new File(filename)));
      return;
    }

    index=p.getParam("list");

    if(index!=null)      
    {
      Vector v=ic.getIndex(index, start, useDate, offset);
      Enumeration iterator=v.elements();
      while(iterator.hasMoreElements())
      {
        InputStream in=(InputStream)iterator.nextElement();
        Conduit conduit=new Conduit(in, System.out, null);
        conduit.run();
        if(iterator.hasMoreElements())
          System.out.println("----------");
      }
      return;
    }

    ic.help();
  }

  public IndexClient()
  {
    this(fixParams(new Params()), Core.logger);
  }

  public IndexClient(Params p, Logger l)
  {
    this(p, l, new SimplifiedClient(fixParams(p), l));
  }

  public IndexClient(Params p, Logger l, SimplifiedClient s)
  {
    super(p, l, true);
    sc=s;
  }

  public static Params fixParams(Params p)
  {
    p.setParam("autoRedirect", "no");
    return p;
  }

  public void help()
  {
    System.out.println("Usage: IndexClient [-insert index -file file] | [-list index] [-future days | -past days]");
    System.out.println("Ex. IndexClient -insert main-index -file test.txt");
    System.out.println("    IndexClient -list main-index -past 1");
  }

  public int insertData(String index, int start, byte[] data, boolean useDate, int offset) throws Exception
  {
    Bucket b=new FileBucket();
    OutputStream os=b.getOutputStream();
    os.write(data);
    os.close();
    insertBucket(index, start, useDate, offset, b);
    return 0;
  }

  public Vector getIndexData(String index, int start, boolean useDate, int offset) throws Exception
  {
    Vector v=getIndex(index, start, useDate, offset);
    Vector v2=new Vector();
    Enumeration iterator=v.elements();
    while(iterator.hasMoreElements())
    {
      InputStream in=(InputStream)iterator.nextElement();
      StringBuffer s=null;
    }
    return v2;
  }

  public int insertBucket(String index, int start, boolean useDate, int offset, Bucket file) throws Exception
  {
    Bucket meta=new NullBucket();
    Date date=new Date();
    int enum = start;
    boolean done=false;
    while(!done)
    {    
      try
      {
        String indexKey;
        if(useDate)
          indexKey=makeIndexKey(index, date, offset, enum);
        else
          indexKey=makeIndexKey(index, enum);
        System.out.println("Inserting "+indexKey);
        sc.put(indexKey, file, meta);
        done=true;
      }
      catch(CollisionException e) { enum++; }
      System.out.println("done");
    }
    return enum;
  }

  public String makeIndexKey(String index, int enum)
  {
    return index+"-"+new Integer(enum).toString();
  }

  public String makeIndexKey(String index, Date date, int offset, int enum)
  {
    long time=date.getTime();
    time=time/1000; // Strip off milliseconds
    time=time-(time%86400); // Move to midnight GMT
    time=time+offset;
    return index+"-"+new Long(time).toString()+"-"+new Integer(enum).toString();
  }

  public Vector getIndex(String name, int start, boolean useDate, int offset)
  {
    int nextIndex = start;
    int missCount = 0;
    Vector v=new Vector();
    Date date=new Date();
    while(missCount<3)
    {
      try
      {
        FileBucket file=new FileBucket();
        Bucket meta=new FileBucket();
        String key;
        if(useDate)
          key=makeIndexKey(name, date, offset, nextIndex);
        else
          key=makeIndexKey(name, nextIndex);
        sc.getData(key, file, meta);
        String newkey=null;

        v.addElement(file.getInputStream());

        System.out.print(".");
        nextIndex++;
      }
      catch(FileNotFoundException e)
      {
        missCount++;
        nextIndex++;
        System.out.print("#");
      }
      catch(Exception e)
      {
        e.printStackTrace();
        missCount++;
        nextIndex++;
      }
    }
    System.out.println();
    return v;
  }
}
