package Freenet.client;
import Freenet.*;
import Freenet.crypt.*;
import Freenet.support.*;
import Freenet.support.io.*;
import Freenet.client.events.*;
import java.io.*;
import java.net.MalformedURLException;
import Freenet.keys.SVK;
import java.util.*;
import Freenet.client.rdf.*;
import Freenet.client.rdf.util.*;
import Freenet.client.rdf.impl.ModelMem;
import Freenet.client.rdf.vocabulary.*;

/**
 * Client for dealing with in-Freenet key indices
 *
 * @author <a href=mailto:blanu@uts.cc.utexas.edu>Brandon Wiley</a>
 **/

public class KeyIndexClient extends IndexClient
{     
  static final String rdfUrl="http://www.w3.org/1999/02/22-rdf-syntax-ns#";
  static final String dcUrl="http://purl.org/dc/elements/1.1/";

  static public void main(String[] args) throws Exception
  {
//    Core.logger=new StandardLogger(System.out, 0, 0);
    Core.logger=new SuppressedLogger();
    Params p = new Params(args);
    KeyIndexClient kic=new KeyIndexClient(p, Core.logger);
    String index=p.getParam("insert");
    String key=p.getParam("key");
    int start=p.getint("start", 0);
    boolean useDate=p.getboolean("useDate", true);
    int future=p.getint("future", 0);
    int past=p.getint("past", 0);
    if((future!=0) && (past!=0))
    {
      System.out.println("Future or past. Make up your mind. You can't have both.");
      return;
    }
    int offset=future*86400;
    if(past!=0)
    {
      offset=past*(-86400);
    }
 
    if(index!=null && key!=null)
    {
	boolean prompt=p.getboolean("prompt", false);
	kic.insertKey(index, key, start, useDate, offset, prompt);
        return;
    }

    index=p.getParam("list");

    if(index!=null)
    {
      Model m=kic.getIndexAsModel(index, start, useDate, offset);
      ResIterator iterator=m.listSubjects();
      if(!iterator.hasNext())
      {
        System.out.println("No keys were found. Try a higher HTL with the -htl option.");
        System.out.println("Also, try yesterday's index with the -past 1 option.");
        System.out.println("Also, make sure that you have the correct name for the index.");
      }
      while(iterator.hasNext())
      {
        Resource resource=iterator.next();
        System.out.println(resource.getURI());
      }
      return;
    }

    index=p.getParam("troll");
    String dest=p.getParam("dest");

    if(index!=null && dest!=null)
    {
      Model m=kic.getIndexAsModel(index, start, useDate, offset);
      kic.insertKeys(dest, start, useDate, offset, m);
      return;
    }
 
    kic.help();
  }

  public KeyIndexClient() { super(); }

  public KeyIndexClient(Params p, Logger l)
  { super(p, l); }

  public KeyIndexClient(Params p, Logger l, SimplifiedClient s)
  { super(p, l, s); }

    public void insertKey(String index, String key) throws Exception {
	insertKey(index, key, 0, true, 0, false);
    }

    public void insertKey(String index, String key, int start, boolean useDate, int offset, boolean prompt) throws Exception
    {
      Model m=new ModelMem();
      Resource resource=makeResource(m, key);
      if(prompt)
        MetadataUtil.addAttributes(resource);
      insertResource(index, start, useDate, offset, resource);
      return;
    }

  public void insertResource(String index, int start, boolean useDate, int offset, Resource resource) throws Exception
  {
    insertBucket(index, start, useDate, offset, makeBucketFromResource(resource));
  }

  public void insertKeys(String index, int start, boolean useDate, int offset, Model m) throws Exception
  {
    insertBucket(index, start, useDate, offset, makeBucketFromModel(m));
  }

  public Bucket makeBucketFromResource(Resource resource) throws IOException, RDFException
  {
    return makeBucketFromModel(resource.getModel());
  }

  public Bucket makeBucketFromModel(Model model) throws IOException, RDFException
  {
    return writeModel(model);
  }

  public Resource makeResource(Model model, String key) throws RDFException
  {
    Resource resource=model.createResource(key);
    resource.addProperty(DC.identifier, key);
    return resource;
  }

  public Bucket writeModel(Model model) throws IOException, RDFException
  {
    FileBucket b=new FileBucket();
    PrintWriter pw=new PrintWriter(b.getOutputStream());
    model.write(pw);
    pw.close();
    return b;
  }

  public Model getIndexAsModel(String name, int start, boolean useDate, int offset) throws RDFException
  {
    Model model = new ModelMem();
    Vector v=getIndex(name, start, useDate, offset);
    Enumeration iterator=v.elements();
    while(iterator.hasMoreElements())
    {
      try
      {
        InputStream in=(InputStream)iterator.nextElement();
        Reader reader=new InputStreamReader(in);
        RDFLoader.load(model, reader, "");
      }
      catch(Exception e)
      {
        System.out.println("x");
      }
    }
    return model;
  }

  public void help()
  {
    System.out.println("Usage: KeyIndexClient [-insert index -key file] | [-list index] [-future days | -past days]");
    System.out.println("Ex. KeyIndexClient -insert main-index -key test.txt");
    System.out.println("    KeyIndexClient -list main-index -past 1");
    System.out.println();
    System.out.println("Some helpful hints:");
    System.out.println("  KeyIndexClient prints some useful status as it searches for keys.");
    System.out.println("  A '#' means that it did not find a key. A '.' means that it did.");
    System.out.println("  Three misses in a row and it will give up looking for keys.");
    System.out.println("  If it doesn't find any keys, try increasing the HTL with '-htl'.");
    System.out.println();
    System.out.println("  By default, KeyIndexClient will insert into today's index.");
    System.out.println("  It will also list keys from today's index.");
    System.out.println("  Today's index changes over to tomorrow's at 12:00am, GMT.");
    System.out.println("  If you want to look at a different day's index, use the -future");
    System.out.println("    and -past parameters.");
  }
}

