package Freenet.client;

import Freenet.*;
import Freenet.Params;
import java.util.*;

/** @deprecated */
public class MapHandler
{
    /*
      NOTES ON CACHING:
      We want to cache MapFiles because they take a while to
      create and are typically hit multiple times with each page
      load as embedded images are requested.

      MapFile references are cached after each lookup.  Different
      threads can make conncurrent lookups on the same MapFile but in
      the case of a race, only the newest version is cached.

      Cached entries go stale after 10 seconds and are purged
      on the next lookup.

      I (giannijohansson@mediaone.net) made these changes to get
      rid of an intermittent stall in fproxy ( < 20010606 ) caused
      by long waits in the old synchronized MapHandler.lookup()
      implementation.
    */
    private static Hashtable mapFileTable = new Hashtable();
    private static final MapFile getMapFile(String mapKey, Params params) {
	MapFile ret = null;

	synchronized (mapFileTable) {
	    // Purge out of date entries from the table.
	    long now = new Date().getTime();
	    for (Enumeration e = mapFileTable.keys() ; e.hasMoreElements() ;) {
		final String key = (String)e.nextElement();
		final MapFile entry = (MapFile)mapFileTable.get(key);
		if (entry.atime + 10000 < now) {
		    mapFileTable.remove(key);
		    //System.err.println("MapHandler.getMapFile -- removed cached entry: " + key);
		}
	    }
	    
	    // look up MapFile
	    ret = (MapFile)mapFileTable.get(mapKey);
	}

	if (ret == null) {
	    // IMPORTANT: Don't hold any locks while reading 
	    //            the MSK mapfile, because it
	    //            can take a long time. multiple minutes!
	    ret = new MapFile(mapKey, params);
	}

	synchronized (mapFileTable) {
	    if (mapFileTable.get(mapKey) == null) {
		mapFileTable.put(mapKey, ret);
		//System.err.println("MapHandler.getMapFile -- added cached entry: " + mapKey);
	    }
	    else {
		// Check the time stamp in case a newer version was cached 
		// by another thread. 
		final MapFile old = (MapFile)mapFileTable.get(mapKey);
		if (old.atime < ret.atime) {
		    mapFileTable.put(mapKey, ret);
		    //System.err.println("MapHandler.getMapFile -- updated cached entry: " + mapKey);
		}
	    }
	}
	return ret;
    }

    /**
     * Return a filename's key from a mapfile. If the mapFile doesn't exist, create it.
     **/
    public static String lookup(String uri, Params params) {
	if (uri.indexOf("//") < 0) return null;
	if (uri.toLowerCase().startsWith("freenet:")) uri = uri.substring(8);
	if (uri.toLowerCase().startsWith("msk@")) uri = uri.substring(4);
	int delim = uri.lastIndexOf("//");
	String mapKey = uri.substring(0,delim);
	String filename = uri.substring(delim+2);
	return getMapFile(mapKey, params).lookup(filename);
    }
}









