package Freenet.client;
import Freenet.*;
import Freenet.crypt.*;
import Freenet.support.*;
import Freenet.support.io.*;
import Freenet.client.events.*;
import java.io.*;
import java.net.MalformedURLException;
import Freenet.keys.SVK;
import java.util.*;
import Freenet.client.rdf.*;
import Freenet.client.rdf.impl.*;
import Freenet.client.rdf.vocabulary.*;

/**
 * Utility methods for manipulating metadata
 *
 * @author <a href=mailto:blanu@uts.cc.utexas.edu>Brandon Wiley</a>
 **/

public class MetadataUtil
{     
  static final String rdfUrl="http://www.w3.org/1999/02/22-rdf-syntax-ns#";
  static final String dcUrl="http://purl.org/dc/elements/1.1/";

  static public void main(String[] args) throws Exception
  {
    if(args.length!=2)
    {
      help();
      return;
    }

    String key=args[0];
    String file=args[1];
    Model model=new ModelMem();

    Resource resource=makeResource(model, key, 1);
    addAttributes(resource);
    FileBucket b = new FileBucket(new File(file));
    writeModelToBucket(model, b);
  }

  public MetadataUtil() {}

  static public Resource makeResource(Model model, String key, int num) throws RDFException
  {
    Resource resource=model.createResource(key);
    return resource;
  }

  static public void help()
  {
    System.out.println("Usage: MetadataUtil key file");
    System.out.println("Ex. MetadataUtil test-key meta.rdf");
    System.out.println("    MetadataUtil KSK@test.html test.rdf");
  }

  static public void writeModelToBucket(Model model, FileBucket b) throws IOException, RDFException
  {
    PrintWriter pw=new PrintWriter(b.getOutputStream());
    model.write(pw);
  }

  static public void addAttributes(Resource resource)
  {
    try
    {
    BufferedReader in=new BufferedReader(new InputStreamReader(System.in));

    System.out.println("Enter the name by which this resource is formally known.");
    System.out.print("Title: ");
    String s=in.readLine();
    if(!s.equals(""))
      resource.addProperty(DC.title, s);

    System.out.println("Enter the name of the resource primarily responsible for making the content of this resource.");
    System.out.print("Creator: ");
    s=in.readLine();
    if(!s.equals(""))
      resource.addProperty(DC.creator, s);

    System.out.println("Enter a one-line description of this resource");
    System.out.print("Description: ");
    s=in.readLine();
    if(!s.equals(""))
      resource.addProperty(DC.description, s);

    System.out.println("Enter the name of the resource responsible for publishing this document (that would be you).");
    System.out.print("Publisher: ");
    s=in.readLine();
    if(!s.equals(""))
      resource.addProperty(DC.publisher, s);

    System.out.println("Enter the MIME type of the resource.");
    System.out.print("Format: ");
    s=in.readLine();
    if(!s.equals(""))
      resource.addProperty(DC.format, s);

    System.out.println("Enter a URL for the license covering this resource.");
    System.out.print("Rights: ");
    s=in.readLine();
    if(!s.equals(""))
      resource.addProperty(DC.rights, s);
    }
    catch(Exception e) {e.printStackTrace();}
  }
}
