package Freenet.client;

/** Represents any single client to node request
  * (DataRequest, InsertRequest, HandshakeRequest, etc.)
  * @author tavin
  */
public abstract class Request extends SimpleEventProducer {

    public Request() {
        super();
    }

    int state = INIT;

    /** Request states */
    public static final int
        INIT         = 0,
        PREPARED     = 1,
        REQUESTING   = 2,
        TRANSFERRING = 3,
        DONE         = 4,
        FAILED       = -1;

    /** @return the current state of the request */
    public int state() {
        return state;
    }

    /** Returns a string describing a state */
    public static String stateOf(int i) {
        switch (i) {
            case INIT:          return "INIT";
            case PREPARED:      return "PREPARED";
            case REQUESTING:    return "REQUESTING";
            case TRANSFERRING:  return "TRANSFERRING";
            case DONE:          return "DONE";
            case FAILED:
            default:            return "FAILED";
        }
    }

    /** Must copy fields from target request to this one
      * @req     the request to copy fields from
      * @return  false if the operation is not supported
      */
//    boolean abstract copyFrom(Request req);

}


