package Freenet.client;
import Freenet.*;
import Freenet.crypt.EntropySource;
import Freenet.support.*;
import Freenet.thread.*;
import java.io.*;
import java.io.EOFException;
import Freenet.servlet.*;
import Freenet.servlet.util.*;
import Freenet.transport.tcpAddress;

/**
 * Handles taking connections for servlets.
 *
 * @author <a href="mailto:blanu@uts.cc.utexas.edu">Brandon Wiley</a>
 **/

public class ServletConnectionHandler implements ERunnable
{
    private static int highid = 0x8001;

    private Connection c;
    private Servlet service;
    private int id;

    // state variables
    private volatile long lastActiveTime;
    private volatile boolean closeOnInactive = false;
    private volatile boolean closed;
    private volatile boolean writing = false;
    private boolean persist = false;

    private Thread exec_instance;
    private static EntropySource sendTimer=new EntropySource(), 
                                 recvTimer=new EntropySource();
    public Object initLock=new Object();
    public Object sendLock=new Object();
    public boolean ready;

    // Constructors
    public ServletConnectionHandler(Connection conn, Servlet s) {
        this.id = highid;
        if (++highid > 0x10000)
            highid = 0x8001;

        this.c=conn;
        this.service=s;
        lastActiveTime = System.currentTimeMillis();

        Core.logger.log(this,"New ServletConnectionHandler with " 
                        + peer(),Logger.DEBUGGING);
    }


    public void start() {
        exec_instance=new Thread(this, peer() + " ServletConnectionHandler");
        exec_instance.start();
    }

    public void setExecutionInstance(EThread e) {
        exec_instance=e.getThread();
    }

    // Public Methods
    public void run() {
        try {
            synchronized(sendLock) {
                Core.logger.log(this, "Authenticating "+c, Logger.MINOR);
                ready=true;
                Core.logger.log(this, c+" authenticated", Logger.MINOR);

                sendLock.notifyAll();
                synchronized (c.initLock) {
                    c.initLock.notifyAll();
                }
                synchronized (initLock) {
                    initLock.notifyAll();
                }
            }        

            c.setReady();
        
            // Get the inputstream for messages (decrypted);
            ServletRequest req = null;
	    try {
		req = new FreenetServletRequest(c.in,
	            c.getPeerAddress().address().equalsHost(new tcpAddress("127.0.0.1", 6666)));
	    }
	    catch (BadAddressException fuck) { // maybe the big bang was god blowing his brains out.
	        req = new FreenetServletRequest(c.in, false);
	    }
            ServletResponse resp=new FreenetServletResponse(c.out);
            try {
                service.service(req, resp); 
            }
            catch(ServletException e) {
                e.printStackTrace();
                Throwable cause = e.getRootCause();
                if (cause != null) cause.printStackTrace();
            }
            catch(IOException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                Core.logger.log(this, "Severe failure in servlet.", Logger.ERROR);
                System.err.println("Severe failure in servlet.");
                e.printStackTrace();
            }

            Core.logger.log(this,"Finished with message", Logger.DEBUGGING);
            lastActiveTime = System.currentTimeMillis();
        }
        finally {
            try {
                if (c.out != null) {
                    synchronized(c.out) {
                        Core.logger.log(this,"Finished with connection - closing",
                                        Logger.DEBUGGING);
                        forceClose();
                    }
                }
                else c.close();
            }
            catch (Throwable e) {
                c.close();
            }
        }
    }
    
    public void close() {
        closed = true;
    }

    /**
     * forces this connection to close. Bad things will happen
     * if you use this carelessly.
     **/
    public void forceClose() {
        closed = true;
        c.close();
        exec_instance.interrupt();
    }

    /**
     * Checks whether the connection is alive
     **/

    public boolean isOpen() {
        return exec_instance.isAlive() && !closed;
    }

    public Address peer() {
        return c.getPeerAddress();
    }

    public Address peer(ListeningAddress laddr) {
        return c.getPeerAddress(laddr);
    }

    public Address local() {
        return c.getMyAddress();
    }

    public Address local(ListeningAddress laddr) {
        return c.getMyAddress(laddr);
    }
}







