package Freenet.client;

import Freenet.*;
import Freenet.support.*;
import java.io.*;
import java.util.*;
import java.lang.reflect.InvocationTargetException;
import Freenet.servlet.*;

public class ServletHandler extends Thread
{
    private Listener listener;
    private ServletConstructor constructor;
    public Vector allowedhosts = null;
    public boolean listen = true;

    public ServletHandler(ThreadGroup tg, String name, ListeningAddress la, ServletConstructor sc) throws ListenException
    {
        super(tg, name);
        listener = ListenerFactory.listen(la);
        constructor=sc;
    }

    public ServletHandler(ThreadGroup tg, String name, ListeningAddress la, ServletConstructor sc, String ah) throws ListenException
    {
        super(tg, name);
        listener = ListenerFactory.listen(la);
        constructor=sc;
        allowedhosts = parseList(ah);
    }

    public ServletHandler(ListeningAddress la, ServletConstructor sc) throws ListenException
    {
        super();
        listener = ListenerFactory.listen(la);
        constructor=sc;
    }

    public ServletHandler(ListeningAddress la, ServletConstructor sc, String ah) throws ListenException
    {
        super();
        listener = ListenerFactory.listen(la);
        constructor=sc;
        allowedhosts = parseList(ah);
    }

    public void run() {
        while (true) {
            try { acceptConnections(); }
            catch (Throwable e) {
                Core.logger.log(this,
                    "Re-executing acceptConnections() loop after severe failure.",
                    Logger.ERROR);
                System.err.println("Re-executing acceptConnections() loop after severe failure.");
                e.printStackTrace();
                try { sleep(5000); } catch (InterruptedException ie) {}
                continue;
            }
            break;
        }
    }

    public void acceptConnections() throws IOException {

        Connection conn = null;
        ServletConnectionHandler c;
    
        while(listen) {
            conn = listener.accept();
            boolean closeConn = true;
            String host = conn.getPeerAddress().toString();
            host = host.substring(host.indexOf('/')+1);
            host = host.substring(0,host.indexOf(':'));
            if (allowedhosts != null && !allowedhosts.contains(host)) {
                Core.logger.log(this,"Rejected connection from "+conn,Logger.MINOR);
                continue;
            }
            Core.logger.log(this,"Accepted connection from "+conn,Logger.MINOR);
            Servlet service = null;
            try { service = constructor.newInstance(); }
            catch (Exception e) {
                Throwable t = null;
                if (e instanceof InvocationTargetException) {
                    t = ((InvocationTargetException) e).getTargetException();
                }
                if (t == null) t = e;
                Core.logger.log(this,
                    "Error instantiating class " + constructor.cls + ": " + t.getMessage(),
                    Logger.ERROR);
                t.printStackTrace();
                conn.close();
                return;
            }
            try {
                // No thread management, start it.
                (new ServletConnectionHandler(conn, service)).start();
                closeConn = false;
            }
            finally {
                if (closeConn) conn.close();
            }
        }
    }

    private Vector parseList(String list) {
        if (list == null) return null; // not configured, allow anything
        if (list.equalsIgnoreCase("all")) return null;
        Vector v = new Vector();
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) v.addElement(st.nextToken().trim());
        return v;
    }
}

