package Freenet.client;
import java.util.Vector;
import java.util.Enumeration;

/**
 * Event handeling for clients. SimpleEventProducer is a simple
 * ClientEventProducer implementation that can be used for others.
 *
 * @author oskar
 **/
public class SimpleEventProducer implements ClientEventProducer {

    private Vector listeners;

    /**
     * Create a new SimpleEventProducer
     *
     **/
    public SimpleEventProducer() {
	listeners = new Vector();
    }

    public void addEventListener(ClientEventListener cel) {
	listeners.addElement(cel);
    }

    public boolean removeEventListener(ClientEventListener cel) {
	return listeners.removeElement(cel);
    }

    /**
     * Sends the ClientEvent to all registered listeners of this object.
     **/
    public void produceEvent(ClientEvent ce) {
	for (Enumeration e = listeners.elements() ; 
	     e.hasMoreElements();) {
	    ((ClientEventListener) e.nextElement()).receive(ce);
	}
    }
}
