package Freenet.client.events;
import Freenet.client.*;
import Freenet.*;

/**
 * The super class of all connection related events
 *
 * @author oskar
 **/
public abstract class ConnectionEvent implements ClientEvent {
    protected Address peer;
    protected String comment;
    protected String messageName;

    protected ConnectionEvent(Address peer, ClientMessageObject m, String comment) {
	this.peer = peer;
	this.comment = comment;
	this.messageName = (m instanceof Message ? 
			    ((Message) m).messageName :
			    "Internal");
    }

}
