package Freenet.client.events;

import java.io.File;
import Freenet.client.*;

/**
 * The RequestCompletedEvent is produced by the library when a
 * request for data is sucessfully completed.  This event
 * contains the file descriptors of the data and, if present, metadata
 * produced by the request.
 *
 * @author scott
 **/
public class RequestCompleteEvent implements ClientEvent {
    public static int code = 0x83;
    protected File[] descriptors;

    public RequestCompleteEvent(File[] descriptors) {
	this.descriptors=descriptors;
    }

    public String getDescription() {
	return "Transfer to temporary files completed.";
    }
    
    public int getCode() {
	return code;
    }

    /**
     * Returns the file's produced by the transfer.
     * The first descriptor will contain the data File, the second,
     * if it exists, contains the metadata File.
     */
    public File[] getDescriptors() {
	return descriptors;
    }
}



