package Freenet.client.events;
import Freenet.client.*;
import Freenet.Message;
import Freenet.Key;

/**
 * The RequestFailedEvent is produced when either an insert or a request
 * has failed for some reason defined in the protocol.
 * This event will contain the Message received that indicated an
 * unsucessful request.
 *
 * @author oskar
 **/
public class RequestFailedEvent implements ClientEvent {
    public static int code = 0x06;
    protected Message result;
    protected ClientKey key;
    
    public RequestFailedEvent(ClientKey k, Message m) {
	key=k;
	result=m;
    }
    
    public String getDescription() {
	return "The request was unsuccessful.  "+result+" was received";
    }
    
    /**
     * Returns the key involved in the failed request
     */
    public ClientKey getKey() {
	return key;
    }

    /**
     * Returns the message received that indicated a failed request
     */
    public Message getMessage() {
	return result;
    }

    public int getCode() {
	return code;
    }
}
