package Freenet.client.events;
import Freenet.client.*;

/**
 * The StateReachedEvent is produced each time the library
 * transitions from one state to another.  
 *
 * @author oskar
 **/
public class StateReachedEvent implements ClientEvent {
    public static int code = 0x00;
    private int state;
    
    public StateReachedEvent(int state) {
	this.state = state;
    }
    
    public String getDescription() {
	return "State \"" + Request.stateOf(state) + "\" reached.";
    }
	
    public int getCode() {
	return code;
    }

    /**
     * Returns the new state of the library
     */
    public int getState() {
	return state;
    }
}
