package Freenet.client.events;

import java.io.File;
import Freenet.client.*;

/**
 * The TransferStartedEvent is produced when a data transfer
 * is started.  
 *
 * @author oskar
 **/
public class TransferStartedEvent implements ClientEvent {
    public static final int METADATA=0, DATA=1, TOTAL=2;
    public static int code = 0x80;
    private long[] segmentLengths;

    public TransferStartedEvent(long lengths[]) {
	super();
	this.segmentLengths=lengths;
    }

    public TransferStartedEvent(long len) {
	this(new long[] {-1, -1, len});
    }
	
    public String getDescription() {
	return "Transfer of " + getLength() + " bytes started.";
    }

    /**
     * Returns the length of data we expect to receive.
     * @return The amount of data to transfer.    
     */
    public long getLength() {
	return segmentLengths[TOTAL];
    }

    public long getMetadataLength() {
	return segmentLengths[METADATA];
    }

    public long getDataLength() {
	return segmentLengths[DATA];
    }

    public int getCode() {
	return code;
    }
}
