package Freenet.client.events;

/**
 * The TransferedEvent is produced every so often by an ongoing transfer.
 * It reports the number of bytes transfered.
 *
 * @author oskar
 **/
public class TransferedEvent extends StreamEvent {
    public static final int code = 0x81;

    /**
     * Create a new TransferedEvent.
     * @param read  The number of bytes read from the stream thus far.
     **/
    public TransferedEvent(long read) {
	super(read);
    }
	
    public String getDescription() {
	return read + " bytes transfered.";
    }

    public int getCode() {
	return code;
    }
}
