/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

package Freenet.client.gui;

import java.util.Properties;
import java.io.*;

/**
 * All configuration information for the client.
 *
 * @author Stephen Blackheath (stephen@blacksapphire.com)
 */
public class ClientProperties
{
  private static final File propertiesFile = new File(".freenet/client.properties");

  private static Properties properties;
  
  static {
    load();
  }

  private ClientProperties()
  {
  }

  /**
   * Attempt to load the properties file from the location specified by 'propertiesFile',
   * and if that doesn't succeed, then load the default properties file from a resource
   * (i.e. from the classpath).
   */
  private static void load()
  {
    properties = new Properties();
    try {
      properties.load(new FileInputStream(propertiesFile));
    }
    catch (IOException e1) {
      try {
        properties.load(ClientProperties.class.getResourceAsStream("/Freenet/client/gui/default.properties"));
      }
        // If we can't read the default properties, then treat it as a fatal error.
      catch (IOException e2) {
        throw new RuntimeException(e2.toString());
      }
    }
  }
  
  public static Properties getProperties()
  {
    return properties;
  }

  public static String get(String key)
  {
    return properties.getProperty(key);
  }

  public static String get(String key, String ifNotThere)
  {
    return properties.getProperty(key, ifNotThere);
  }
}
