/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

package Freenet.client.gui;

import Freenet.*;
import Freenet.support.*;
import Freenet.client.*;
import java.io.FileNotFoundException;

/**
 * Encapsulates all configuration that pertains to a browser.  This includes the Freenet
 * connection parameters.
 *
 * @author Stephen Blackheath (stephen@blacksapphire.com)
 */
public class Configuration
{
  private Params params;

  public Configuration(String[] args)
  {
    try {
      params = new Params(Params.defaultRCFiles, args);
    }
    catch (FileNotFoundException e) {
        // TO DO: Dialog box.
      System.err.println("Warning: Can't find configuration file!");
      params = new Params(args);
    }
  }

  public Params getParams()
  {
    return params;
  }
}
