/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

package Freenet.client.gui;

import Freenet.FieldSet;

/**
 * A listener for events relating to the loading of documents from some
 * source.
 *
 * @author Stephen Blackheath (stephen@blacksapphire.com)
 */
public interface DocumentListener
{
  /**
   * Set the listener to its initial state in the middle of a running stream.  Clears the
   * metadata and any received text.  Received streams can be terminated by the source and
   * replaced with a new stream at any time.  All document listeners must be able to cope
   * with this.  This method needn't be efficient, because the implementor can assume that
   * this method won't be called for the initial transfer.  It's only for re-starting an
   * already running transfer.
   */
  public void reset();

  /**
   * Indicate the Freenet request state.  See Freenet.client.Client for values. 
   */
  public void setState(int state);

  /**
   * Let the listener have a copy of the metaData for this document.  Caller is required
   * to call this method with a non-null value.  If there is no metaData, caller should
   * construct an empty Properties object and pass it.  This method MUST be called
   * before the first call to push(..).
   *
   * <p>contentLength is the content length of the data if known, or -1L if unknown.   
   */
  public void setMetaData(FieldSet metaData, long contentLength);
  
  /**
   * Blocks of data are pushed to the listener through this method, and when this pushing
   * is complete, the caller calls finish().
   */
  public void push(byte[] data, int offset, int length);

  /**
   * Called after multiple calls to push to signify that it's the end of the data.
   */
  public void finish(boolean success, Exception[] exceptions);  
}
