/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

package Freenet.client.gui;

import java.awt.Container;
import java.awt.BorderLayout;
import javax.swing.JProgressBar;
import javax.swing.JPanel;

/**
 * A dialog box in a frame that pops up to indicate the progress of a save or
 * insert. 
 *
 * @author Stephen Blackheath (stephen@blacksapphire.com)
 */
public class DocumentProgressIndicator
  extends JPanel
  implements ProgressIndicator
{
  private JProgressBar progressBar;
  private long         maximum;

  public DocumentProgressIndicator()
  {
    setLayout(new BorderLayout());
    add("Center", progressBar = new JProgressBar());
    progressBar.setMaximum(10000);
  }

  /**
   * Add a listener that gets notified when a command is issued by the progress
   * indicator.  The most obvious command is the user requesting that the transfer
   * be cancelled.
   */
  public void addProgressIndicatorListener(ProgressIndicatorListener listener)
  {
    // We don't have a 'cancel transfer' button, so this functionality is not required.
  }

  public void removeProgressIndicatorListener(ProgressIndicatorListener listener)
  {
    // We don't have a 'cancel transfer' button, so this functionality is not required.
  }

  /**
   * Set the maximum value of the progress indicator. 
   */
  public void setMaximum(long maximum)
  {
    this.maximum = maximum;
  }

  /**
   * Set the current value of the progress indicator.
   */
  public void setValue(long value)
  {
    if (maximum != -1L && maximum > 0)
      progressBar.setValue((int) ((value * 10000L)/maximum));
  }

  /**
   * Set some text that will appear on the indicator.
   */
  public void setText(String text)
  {
    progressBar.setString(text);
    progressBar.setStringPainted(true);
  }

  /**
   * Dispose of the progress indicator once the transfer has completed.
   */
  public synchronized void dispose()
  {
    Container c = getParent();
    if (c != null) {
      c.remove(this);
      c.invalidate();
      c.validate();
    }
  }
}
