/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

package Freenet.client.gui;

import Freenet.FieldSet;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JLabel;
import java.io.FileNotFoundException;

/**
 * A viewer that knows how to present text.
 *
 * @author Stephen Blackheath (stephen@blacksapphire.com)
 */
public class ErrorViewer
  extends JPanel
  implements Viewer
{
  public ErrorViewer()
  {
  }

  /**
   * Set the listener to its initial state in the middle of a running stream.  Clears the
   * metadata and any received text.  Received streams can be terminated by the source and
   * replaced with a new stream at any time.  All document listeners must be able to cope
   * with this.  This method needn't be efficient, because the implementor can assume that
   * this method won't be called for the initial transfer.  It's only for re-starting an
   * already running transfer.
   */
  public void reset()
  {
    // Error viewer never receives any data.
  }

  /**
   * Indicate the Freenet request state.  See Freenet.client.Client for values. 
   */
  public void setState(int state)
  {
  }

  /**
   * Let the viewer have a copy of the metaData for this document.  Caller is required
   * to call this method with a non-null value.  If there is no metaData, caller should
   * construct an empty Properties object and pass it.  This method MUST be called
   * before the first call to push(..).
   *
   * <p>contentLength is the content length of the data if known, or -1L if unknown.   
   */
  public void setMetaData(FieldSet metaData, long contentLength)
  {
    // Error viewer never receives any data.
  }

  /**
   * Blocks of data are pushed to the viewer through this method, and when this pushing
   * is complete, the caller calls finish().
   */
  public void push(byte[] data, int offset, int length)
  {
    // Error viewer never receives any data.
  }

  /**
   * Sets the document.
   */
  public void setDocument(Document doc)
  {
    // I have no idea what this does.
  }

  /**
   * Called after multiple calls to push to signify that it's the end of the data.
   */
  public void finish(boolean success, Exception[] exceptions)
  {
    setLayout(new BorderLayout());
    if (exceptions.length == 0)
      exceptions = new Exception[] {null};
    JPanel topPanel = new JPanel();
    topPanel.setLayout(new GridLayout(exceptions.length, 1));
    add("Center", topPanel);
    for (int i = 0; i < exceptions.length; i++)
      topPanel.add(new JLabel(describeNicely(exceptions[i]), JLabel.CENTER));
  }
  
  private String describeNicely(Exception e)
  {
    if (e instanceof FileNotFoundException) {
      return "Could not locate document";
    }
    else
      return e.toString();
  }
}
