/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

package Freenet.client.gui;

import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import java.awt.Insets;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Color;
import java.awt.event.ActionListener;

/**
 * The bit at the top of the browser where you can enter a key.
 *
 * @author Stephen Blackheath
 */
public class KeyEntryField
  extends JPanel
{
  private Browser browser;
  
  private JLabel uriLabel = new JLabel("URI");
  private JTextField uri = new JTextField();
  
  public KeyEntryField(Browser browser)
  {
    this.browser = browser;
    GridBagLayout gb = new GridBagLayout();
    setLayout(gb);
    
    GridBagConstraints c = new GridBagConstraints();
    c.insets = new Insets(3, 5, 3, 1);
    c.fill = GridBagConstraints.NONE;
    c.gridheight = 1;
    c.gridwidth = 1;
    gb.setConstraints(uriLabel, c);
    add(uriLabel);
    c.insets = new Insets(3, 0, 3, 5);
    c.gridx = 1;
    c.weightx = 1.0;
    c.fill = GridBagConstraints.HORIZONTAL;
    gb.setConstraints(uri, c);
    
    add(uri);
  }
  
  public void setForeground(Color fg)
  {
    super.setForeground(fg);
      // Make sure it's not null, because we get called by the superclass
      // during construction.
    if (uriLabel != null)
      uriLabel.setForeground(fg);
  }

  public void setBackground(Color bg)
  {
    super.setBackground(bg);
    if (uri != null) {
      Color highlight = new Color(
        limit(255.0-(255.0-bg.getRed()*0.75)),
        limit(255.0-(255.0-bg.getGreen()*0.75)),
        limit(255.0-(255.0-bg.getBlue()*0.75)));
      Color shadow = new Color(
        limit(255.0-(255.0-bg.getRed()*1.5)),
        limit(255.0-(255.0-bg.getGreen()*1.5)),
        limit(255.0-(255.0-bg.getBlue()*1.5)));
      EtchedBorder border = new EtchedBorder(EtchedBorder.RAISED,
        highlight, shadow);
      uri.setBorder(border);
    }
  }
  
  private static int limit(double colourValue)
  {
    int value = (int) colourValue;
    if (value < 0) return 0; else
    if (value > 255) return 255; else
      return value;
  }
  
  public void addActionListener(ActionListener listener)
  {
    uri.addActionListener(listener);
  }
  
  public void removeActionListener(ActionListener listener)
  {
    uri.removeActionListener(listener);
  }
  
  /**
   * Get the text from the key selection text field.
   */
  public String getText()
  {
    return uri.getText();
  }
  
  /**
   * Clear the text out of the key selection text field.
   */
  public void clearText()
  {
    uri.setText("");
  }
}
