/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

package Freenet.client.gui;

import java.util.Properties;
import java.util.Enumeration;
import java.util.Vector;

/**
 * This class knows all about MIME types.  It can guess a MIME type from a file
 * extension, and it knows what external viewer to use for a given MIME type.
 *
 * @author Stephen Blackheath (stephen@blacksapphire.com)
 */
public class MIMEMapper
{
  /**
   * Guess the MIME type given the extension of a URI.
   */
  public static String guessMIMEType(String extension)
  {
    String mimeType = ClientProperties.get("extension."+extension);
      // If we can't resolve the MIME type, then default to binary.
    if (mimeType == null)
      mimeType = "application/octet-stream";
    return mimeType;  
  }
  
  public static Viewer getViewer(String mimeType)
  {
    String clazz = ClientProperties.get("viewer."+mimeType);
    
    if (clazz == null || clazz.length() == 0)
      return new BinaryViewer();
    
    try {
      return (Viewer) Class.forName(clazz).newInstance();
    }
    catch (ClassNotFoundException e) {
      throw new InternalError(e.toString());
    }
    catch (InstantiationException e) {
      throw new InternalError(e.toString());
    }
    catch (IllegalAccessException e) {
      throw new InternalError(e.toString());
    }
  }

  /**
   * Get the list of all mime types that have viewers attached to them.
   */
  public static String[] getMIMETypesWithViewers()
  {
    if (mimeTypesWithViewers == null) {
      Properties props = ClientProperties.getProperties();
      Vector types = new Vector();
      Enumeration enum = props.keys();
      while (enum.hasMoreElements()) {
        String key = (String) enum.nextElement();
        if (key.startsWith("viewer.")) {
          String viewer = (String) props.get(key);
          String mimeType = key.substring(7);
          if (viewer != null)
            if (viewer.length() != 0)
              types.addElement(mimeType);
        }
      }
      String[] typesAry = new String[types.size()];
      types.copyInto(typesAry);
      mimeTypesWithViewers = typesAry;
    }
    return mimeTypesWithViewers;
  }
  private static String[] mimeTypesWithViewers;
}
