/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

package Freenet.client.gui;

/**
 * An abstraction of a progress indicator.  A progress indicator shows how far
 * a transfer has gone.  The user can send commands through it.  The only command
 * which is currently supported is 'cancel transfer'.
 *
 * @author Stephen Blackheath (stephen@blacksapphire.com)
 */
public interface ProgressIndicator
{
  /**
   * Add a listener that gets notified when a command is issued by the progress
   * indicator.  The most obvious command is the user requesting that the transfer
   * be cancelled.
   */
  public void addProgressIndicatorListener(ProgressIndicatorListener listener);
  
  public void removeProgressIndicatorListener(ProgressIndicatorListener listener);

  /**
   * Set the maximum value of the progress indicator. 
   */
  public void setMaximum(long maximum);
  
  /**
   * Set the current value of the progress indicator.
   */
  public void setValue(long value);
  
  /**
   * Set some text that will appear on the indicator.
   */
  public void setText(String text);
  
  /**
   * Dispose of the progress indicator once the transfer has completed.
   */
  public void dispose(); 
}
