/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

package Freenet.client.gui;

import Freenet.FieldSet;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

/**
 * A viewer for unknown data types.
 *
 * @author Stephen Blackheath (stephen@blacksapphire.com)
 */
public class TextViewer
  extends JScrollPane
  implements Viewer
{
  private FieldSet metaData;
  private ByteArrayOutputStream bos = new ByteArrayOutputStream();  

  public TextViewer()
  {
  }
    // Hand the viewer a reference to the document so it can get efficient
    // access to the contents of the document rather than having to cache the
    // contents of the document itself (which would be inefficient).
  public void setDocument(Document doc)
  {
    // Do it the inefficient way.  Improve this at some later stage maybe.
  }

  /**
   * Set the listener to its initial state in the middle of a running stream.  Clears the
   * metadata and any received text.  Received streams can be terminated by the source and
   * replaced with a new stream at any time.  All document listeners must be able to cope
   * with this.  This method needn't be efficient, because the implementor can assume that
   * this method won't be called for the initial transfer.  It's only for re-starting an
   * already running transfer.
   */
  public void reset()
  {
    bos.reset();
  }

  /**
   * Indicate the Freenet request state.  See Freenet.client.Client for values. 
   */
  public void setState(int state)
  {
  }

  /**
   * Let the viewer have a copy of the metaData for this document.  Caller is required
   * to call this method with a non-null value.  If there is no metaData, caller should
   * construct an empty Properties object and pass it.  This method MUST be called
   * before the first call to push(..).
   *
   * <p>contentLength is the content length of the data if known, or -1L if unknown.   
   */
  public void setMetaData(FieldSet metaData, long contentLength)
  {
    this.metaData = metaData;
  }

  /**
   * Blocks of data are pushed to the viewer through this method, and when this pushing
   * is complete, the caller calls finish().
   */
  public void push(byte[] data, int offset, int length)
  {
    bos.write(data, offset, length); 
  }

  /**
   * Called after multiple calls to push to signify that it's the end of the data.
   */
  public void finish(boolean success, Exception[] exceptions)
  {
      // TO DO: Extract encoding from the meta data.
    String encoding = "UTF8";

    String text;
    try {
      text = new String(bos.toByteArray(), encoding);
    }
    catch (UnsupportedEncodingException e1) {
      try {
        text = new String(bos.toByteArray(), "UTF8");
      }
        // Won't happen, because all JVMs have 'UTF8' encoding.
      catch (UnsupportedEncodingException e2) {
        throw new InternalError(e2.toString());
      }
    }
    bos = null;  // <-- evict bos from memory now we don't need it.
    JTextArea ta = new JTextArea(text);
    setViewportView(ta);
  }
}
