/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

 */

package Freenet.client.gui;

import java.util.Properties;

/**
 * The base class for classes that know how to render different types of content.
 * Subclasses should extend a JComponent or one of its subclasses, and implement
 * Viewer.
 *
 * <p>Yes I know this is a bit strange, but it's convenient.
 *
 * @author Stephen Blackheath (stephen@blacksapphire.com)
 */
public interface Viewer
  extends DocumentListener
{
  // Note: Document isn't very clever about locking, so the DocumentListener
  // implementation mustn't do anything time-consuming.
  
    // Hand the viewer a reference to the document so it can get efficient
    // access to the contents of the document rather than having to cache the
    // contents of the document itself (which would be inefficient).
  public void setDocument(Document doc);
}
