package Freenet.client.listeners;

import Freenet.client.*;
import Freenet.client.events.*;
import java.util.*;

/**
  * The DoneListener will call notify on itself when the request reaches 
  * a terminal state (either DONE or FAILED).
  */
public class DoneListener implements ClientEventListener {

    private boolean isComplete = false;

    public synchronized void waitEvent() throws InterruptedException {
        while(!isComplete) wait();
    }
          
    public void receive(ClientEvent ce) {
        StateReachedEvent sr;
        try   { sr = (StateReachedEvent) ce;   }
        catch (ClassCastException e) { return; }
        if (sr.getState() != Request.FAILED && sr.getState() != Request.DONE)
            return;
        synchronized(this) {
            isComplete=true;
            notifyAll();  
        }
    }
}

