package Freenet.client.listeners;

import Freenet.client.*;
import Freenet.client.events.*;
import java.util.Stack;

public class TransferStartedListener implements ClientEventListener
{
    public TransferStartedEvent event = null;
    private boolean isComplete = false;
    
    public synchronized void waitEvent() throws InterruptedException {
        while(!isComplete) wait();
    }

    public void receive(ClientEvent ce) {
        if (ce instanceof TransferStartedEvent) {
            event = (TransferStartedEvent) ce;
            synchronized (this) {
                isComplete = true;
                notifyAll();  
            }
        }
        else if (ce instanceof StateReachedEvent &&
                 ((StateReachedEvent) ce).getState() == Request.FAILED) {
            synchronized (this) {
                isComplete = true;
                notifyAll();
            }
        }
    }
}

