/*
 *  (c) Copyright Hewlett-Packard Company 2000 
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Store.java
 *
 * Created on 15 August 2000, 14:25
 */

package Freenet.client.rdf.impl;

import Freenet.client.rdf.*;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;


/**
 *
 * @author  bwm
 * @version 
 */
class Store extends Object {
    
    HashSet statements = new HashSet();
    
    NodeMap subjects = new NodeMap();
    NodeMap predicates = new NodeMap();
    NodeMap objects = new NodeMap();

    /** Creates new Store */
    public Store() {
    }

    protected void add(Statement s) {
        if (statements.contains(s)) return;
        statements.add(s);
        subjects.add(s.getSubject(), s);
        predicates.add(s.getPredicate(), s);
        objects.add(s.getObject(),s);
    }
    
    protected void remove(Statement s) {
        statements.remove(s);
        subjects.remove(s.getSubject(), s);
        predicates.remove(s.getPredicate(), s);
        objects.remove(s.getObject(), s);
    }
    
    protected int size() {
        return statements.size();
    }
    
    protected boolean contains(Statement s) {
        return statements.contains(s);
    }
    
    protected Iterator list() {
        return statements.iterator();
    }
    
    protected Iterator listBySubjectHash(Resource subject) {
        return subjects.iterator(subject);
    }
    
    protected Iterator listByPredicateHash(Property property) {
        return predicates.iterator(property);
    }
    
    protected Iterator listByObjectHash(RDFNode object) {
        return objects.iterator(object);
    }
    
    protected class NodeMap {
        HashMap map = new HashMap();
        
        protected void add(RDFNode o, Statement s) {
            LinkedList l = (LinkedList) map.get(o);
            if (l==null) {
                l = new LinkedList();
                map.put(o,l);
            }
            l.add(s);
        }
        
        protected void remove(RDFNode o, Statement s) {
            LinkedList l = (LinkedList) map.get(o);
            if (l != null) {
                l.remove(s);
                if (l.size() == 0) {
                    map.put(o, null);
                }
            }
        }
        
        protected Iterator iterator(RDFNode o) {
            LinkedList l = (LinkedList) map.get(o);
            if (l==null) {
                return (new LinkedList()).iterator();
            } else {
                return l.iterator();
            }
        }
    }        
}