/*
 *  (c) Copyright Hewlett-Packard Company 2000 
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * AltImpl.java
 *
 * Created on 08 August 2000, 16:39
 */

package Freenet.client.rdf.util;

import Freenet.client.rdf.*;
import Freenet.client.rdf.vocabulary.RDF;

/** An implementation of Alt.
 *
 * @author  bwm
 */
public class AltImpl extends ContainerImpl implements Alt {

    /** Creates new AltMem */
    public AltImpl(Model model) throws RDFException {
        super(model);
    }
    
    public AltImpl(String uri, Model model) throws RDFException {
        super(uri, model);
    }
    
    public AltImpl(Resource r, Model m) throws RDFException {
        super(r, m);
    }
    
    public RDFNode getDefault() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getObject();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public Resource getDefaultResource() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getResource();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public Literal getDefaultLiteral() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getLiteral();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public boolean getDefaultBoolean() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getBoolean();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public byte getDefaultByte() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getByte();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public short getDefaultShort() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getShort();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public int getDefaultInt() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getInt();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public long getDefaultLong() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getLong();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public char getDefaultChar() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getChar();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public float getDefaultFloat() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getFloat();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public double getDefaultDouble() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getDouble();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public String getDefaultString() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getString();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public String getDefaultLanguage() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getLanguage();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public Resource getDefaultResource(ResourceF f) throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getResource(f);
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public Object getDefaultObject(ObjectF f)   throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getObject(f);
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public Alt getDefaultAlt() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getAlt();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public Bag getDefaultBag() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getBag();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    public Seq getDefaultSeq() throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            return getDefaultStatement().getSeq();
        } else {
            throw new RDFException(RDFException.ALTHASNODEFAULT);
        }
    }
    
    public Alt setDefault(RDFNode o) throws RDFException {
        Statement stmt = getDefaultStatement();
        if (stmt != null) {
            model.remove(stmt);
        }
        model.add(this, RDF.li(1), o);
        return this;
    }    
    public Alt setDefault(boolean o) throws RDFException {
        return setDefault(new LiteralImpl(o));
    }
    public Alt setDefault(long o) throws RDFException {
        return setDefault(new LiteralImpl(o));
    }    
    public Alt setDefault(char o) throws RDFException {
        return setDefault(new LiteralImpl(o));
    }        
    public Alt setDefault(float o) throws RDFException {
        return setDefault(new LiteralImpl(o));
    } 
    public Alt setDefault(double o) throws RDFException {
        return setDefault(new LiteralImpl(o));
    }    
    public Alt setDefault(String o) throws RDFException {
        return setDefault(new LiteralImpl(o));
    }    
    public Alt setDefault(String o, String l) throws RDFException {
        return setDefault(new LiteralImpl(o,l));
    }      
    public Alt setDefault(Object o) throws RDFException {
        return setDefault(new LiteralImpl(o));
    }
    
    public Resource port(Model m) throws RDFException {
        if (model == m) {
            return this;
        } else {
            AltImpl r = new AltImpl(uri, m);
            r.id = id;
            return r;
        }
    }
    
    protected Statement getDefaultStatement() throws RDFException {
        StmtIterator iter = model.listStatements(
                             new SelectorImpl(this, RDF.li(1), (RDFNode) null));
        if (!iter.hasNext()) {
            return null;
        }
        return iter.next();
    }
}
