/*
 *  (c) Copyright Hewlett-Packard Company 2000 
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ContainerImpl.java
 *
 * Created on 08 August 2000, 16:33
 */

package Freenet.client.rdf.util;

import Freenet.client.rdf.*;
import Freenet.client.rdf.vocabulary.RDF;

/** An internal class not normally of interest to application developers.
 *  A base class on which the other containers are built.
 *
 * @author  bwm
 */
public class ContainerImpl extends ResourceImpl
                           implements Container, ContainerI {
    
    static NodeIteratorFactory iteratorFactory;
    
    static {
        iteratorFactory = new ContNodeIteratorFactoryImpl();
    }

    /** Creates new ContainerImpl */
    public ContainerImpl(Model model) throws RDFException {
        super(model);
    }
    
    public ContainerImpl(String uri, Model model) throws RDFException {
        super(uri, model);
    }
    
    public ContainerImpl(Resource r, Model model) throws RDFException {
        super(r, model);
    }
    
    public Container add(RDFNode n) throws RDFException {
        int i = size();
        addProperty(RDF.li(i+1), n);
        return this;
    }
    public Container add(boolean o) throws RDFException {
        return add(new LiteralImpl(o));
    }
    public Container add(long o) throws RDFException {
        return add(new LiteralImpl(o));
    }
    public Container add(char o) throws RDFException {
        return add(new LiteralImpl(o));
    }
    public Container add(float o) throws RDFException {
        return add(new LiteralImpl(o));
    }
    public Container add(double o) throws RDFException {
        return add(new LiteralImpl(o));
    }
    public Container add(String o) throws RDFException {
        return add(new LiteralImpl(o));
    }
    public Container add(String o, String l) throws RDFException {
        return add(new LiteralImpl(o,l));
    }
    public Container add(Object o) throws RDFException {
        return add(new LiteralImpl(o));
    }
 
    public boolean contains(RDFNode n) throws RDFException {
        return ((ModelI)model).containerContains(this, n);
    }
    public boolean contains(boolean o) throws RDFException {
        return contains(new LiteralImpl(o));
    }
    public boolean contains(long o) throws RDFException {
        return contains(new LiteralImpl(o));
    }
    public boolean contains(char o) throws RDFException {
        return contains(new LiteralImpl(o));
    }
    public boolean contains(float o) throws RDFException {
        return contains(new LiteralImpl(o));
    }
    public boolean contains(double o) throws RDFException {
        return contains(new LiteralImpl(o));
    }
    public boolean contains(String o) throws RDFException {
        return contains(new LiteralImpl(o));
    }
    public boolean contains(String o, String l) throws RDFException {
        return contains(new LiteralImpl(o,l));
    }
    public boolean contains(Object o) throws RDFException {
        return contains(new LiteralImpl(o));
    }
    
    public NodeIterator iterator() throws RDFException {
        return ((ModelI)model).listContainerMembers(this, iteratorFactory);
    }
        
    public int size() throws RDFException {
        return ((ModelI)model).containerSize(this);
    }
    
    public Container remove(Statement s) throws RDFException {
        int size = size();
        Statement last = null;
        if (s.getPredicate().getOrdinal() == size) {       // if last
            model.remove(s);
        } else {
            last = model.getProperty(this, RDF.li(size));
            s.set(last.getObject());
            model.remove(last);
        }
        if (size() != (size -1)) 
            throw new RDFException(RDFException.ASSERTIONFAILURE); 
        return this;
    }
    
    public Container remove(int index, RDFNode object) throws RDFException {
        remove(model.createStatement(this, RDF.li(index), object));
        return this;
    }
}
