/*
 *  (c) Copyright Hewlett-Packard Company 2000 
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * EnhSeq.java
 *
 * Created on 17 August 2000, 08:33
 */

package Freenet.client.rdf.util;

import Freenet.client.rdf.*;

/** A base class for supporting enhanced Seq's.  An enhanced resource is a
 * resource with extended functionality, provided either by the application or
 * by the implementation.  This class is a base class with Seq functionality
 * which can be extended by the application.
 *
 * <p>Enhanced resources are implemented using encapsulation.  An enhanced
 *   resource contains an embedded resource which provides the basic
 *   functionality of the resource.  The application code provides any extended
 *   behaviour.  This method was chosen, rather than subclassing, so as not
 *   to constrain the applications need to create its own class hierarchy.</p>
 *
 * <p>This class is intended to be subclassed by the application to provide the
 *   specific enhanced behaviour.  It provides Seq funcationality and some
 *   basic housekeeping functions to support the encapsulation.</p>
 *
 * @author bwm
 */
public class EnhSeq extends EnhContainer implements Seq {
    protected Seq seq;
    
    public EnhSeq(String uri, Model m) throws RDFException {
        super(m.createSeq(uri));
        seq = (Seq) resource;
    }
    
    public EnhSeq(Model m) throws RDFException {
        super(m.createSeq());
        seq = (Seq) resource;
    }

    protected EnhSeq(Resource r) throws RDFException {
        super(r.getModel().getSeq(r));
        seq = (Seq) resource;
    }
    
    public Resource getResource(int index) throws RDFException {
        return seq.getResource(index);
    }
    public Literal getLiteral(int index) throws RDFException {
        return seq.getLiteral(index);
    }
    public RDFNode getObject(int index) throws RDFException {
        return seq.getObject(index);
    }    
    public boolean getBoolean(int index) throws RDFException {
        return seq.getBoolean(index);
    }
    public byte getByte(int index) throws RDFException {
        return seq.getByte(index);
    }
    public short getShort(int index) throws RDFException {
        return seq.getShort(index);
    }
    public int getInt(int index) throws RDFException {
        return seq.getInt(index);
    }
    public long getLong(int index) throws RDFException {
        return seq.getLong(index);
    }
    public char getChar(int index) throws RDFException {
        return seq.getChar(index);
    }
    public float getFloat(int index) throws RDFException {
        return seq.getFloat(index);
    }
    public double getDouble(int index) throws RDFException {
        return seq.getDouble(index);
    }
    public String getString(int index) throws RDFException {
        return seq.getString(index);
    }
    public String getLanguage(int index) throws RDFException {
        return seq.getLanguage(index);
    }
    public Object getObject(int index, ObjectF f) throws RDFException {
        return seq.getObject(index, f);
    }
    public Resource getResource(int index, ResourceF f) throws RDFException{
        return seq.getResource(index, f);
    }
    public Bag getBag(int index) throws RDFException {
        return seq.getBag(index);
    }
    public Alt getAlt(int index) throws RDFException {
        return seq.getAlt(index);
    }
    public Seq getSeq(int index) throws RDFException {
        return seq.getSeq(index);
    }

    public Seq set(int index, RDFNode o) throws RDFException {
        return seq.set(index, o);
    }
    public Seq set(int index, boolean o) throws RDFException {
        return seq.set(index, o);
    }
    public Seq set(int index, long o) throws RDFException {
        return seq.set(index, o);
    }
    public Seq set(int index, float o) throws RDFException {
        return seq.set(index, o);
    }
    public Seq set(int index, double o) throws RDFException {
        return seq.set(index, o);
    }
    public Seq set(int index, char o) throws RDFException {
        return seq.set(index, o);
    }
    public Seq set(int index, String o) throws RDFException {
        return seq.set(index, o);
    }
    public Seq set(int index, String o, String l) throws RDFException {
        return seq.set(index, o, l);
    }
    public Seq set(int index, Object o) throws RDFException {
        return seq.set(index, o);
    }
    
    public Seq add(int index, RDFNode o) throws RDFException {
        return seq.add(index, o);
    }   
    public Seq add(int index, boolean o) throws RDFException {
        return seq.add(index, o);
    }
    public Seq add(int index, long o) throws RDFException {
        return seq.add(index, o);
    }
    public Seq add(int index, char o) throws RDFException {
        return seq.add(index, o);
    }
    public Seq add(int index, float o) throws RDFException {
        return seq.add(index, o);
    }
    public Seq add(int index, double o) throws RDFException {
        return seq.add(index, o);
    }
    public Seq add(int index, String o) throws RDFException {
        return seq.add(index, o);
    }
    public Seq add(int index, String o, String l) throws RDFException {
        return seq.add(index, o, l);
    }
    public Seq add(int index, Object o) throws RDFException {
        return seq.add(index, o);
    }
    
     public NodeIterator iterator() throws RDFException {
        return seq.iterator();
    }
    
    public Container remove(Statement s) throws RDFException{
        return seq.remove(s);
    }
    public Seq remove(int index) throws RDFException {
        return seq.remove(index);
    }
    public Container remove(int index, RDFNode o) throws RDFException {
        return ((ContainerI)seq).remove(index, o);
    }
    
    public int indexOf(RDFNode o) throws RDFException {
        return seq.indexOf(o);
    }    
    public int indexOf(boolean o) throws RDFException {
        return seq.indexOf(o);
    }
    public int indexOf(long o) throws RDFException {
        return seq.indexOf(o);
    }
    public int indexOf(char o) throws RDFException {
        return seq.indexOf(o);
    }
    public int indexOf(float o) throws RDFException {
        return seq.indexOf(o);
    }
    public int indexOf(double o) throws RDFException {
        return seq.indexOf(o);
    }
    public int indexOf(String o) throws RDFException {
        return seq.indexOf(o);
    }
    public int indexOf(String o, String l) throws RDFException {
        return seq.indexOf(o, l);
    }
    public int indexOf(Object o) throws RDFException {
        return seq.indexOf(o);
    }
}
