/*
 *  (c) Copyright Hewlett-Packard Company 2000 
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * LiteralImpl.java
 *
 * Created on 03 August 2000, 14:42
 */

package Freenet.client.rdf.util;

import Freenet.client.rdf.*;

import java.lang.Byte;
import java.lang.Short;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Character;
import java.lang.Float;
import java.lang.Double;
import java.lang.NumberFormatException;

/** An implementation of Literal.
 *
 * @author  bwm
 */
public class LiteralImpl extends Object implements Literal {
    
    String literal;
    String language = "";

    public LiteralImpl(boolean b) {literal = String.valueOf(b);}
    public LiteralImpl(long l)    {literal = String.valueOf(l);}
    public LiteralImpl(char c)    {literal = String.valueOf(c);}
    public LiteralImpl(float f)   {literal = String.valueOf(f);}    
    public LiteralImpl(double d)  {literal = String.valueOf(d);}
    public LiteralImpl(String s)  {literal = s;}
    public LiteralImpl(String s, String l) {literal = s; language=l;}
    public LiteralImpl(Object o)  {literal = o.toString();}
    
    public String toString() {
        return literal;
    }
    
    public int hashCode() {
        return literal == null ? 0 : literal.hashCode();
    }
    
    public boolean equals(Object o) {
        if (o instanceof Literal) {            
             return literal.equals(((Literal)o).toString())
                 && language.equals(((Literal)o).getLanguage());
        } else if (o instanceof String) {
            return literal.equals(o);
        } else {
            return false;
        }
    }    

    public boolean getBoolean() throws RDFException {
        if (literal.equals("true")) {
            return true;
        } else if (literal.equals("false")) {
            return false;
        } else {
            throw new RDFException(RDFException.INVALIDBOOLEANFORMAT);
        }
    }
    public byte getByte() throws RDFException {
        return Byte.parseByte(literal);
    }
    public short getShort() throws RDFException {
        return Short.parseShort(literal);
    }
    public int getInt() throws RDFException {
        return Integer.parseInt(literal);
    }
    public long getLong() throws RDFException {
        return Long.parseLong(literal);
    }
    public char getChar() throws RDFException {
        if (literal.length()==1) {
            return (literal.charAt(0));
        } else {
            throw new RDFException(RDFException.LITERALNOTCHAR);
        }
    }
    public float getFloat() throws RDFException {
        return Float.parseFloat(literal);
    }
    public double getDouble() throws RDFException {
        return Double.parseDouble(literal);
    }
    public String getString() throws RDFException {
        return literal;
    }
    public Object getObject(ObjectF f) throws RDFException {
        try {
            return f.createObject(literal);
        } catch (Exception e) {
            throw new RDFException(e);
        }
    }
    public String getLanguage() {
        return language;
    }
}
