/*
 *  (c) Copyright Hewlett-Packard Company 2000 
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Util.java
 *
 * Created on 01 August 2000, 16:31
 */

package Freenet.client.rdf.util;

/** Some utility functions.
 *
 * @author  bwm
 */
public class Util extends Object {
    
    public static final String CLASSPATH = "jena";
    
    /** Given a URI, determine the split point between the namespace part
     * and the localname part.
     *
     * <p>FIXME: This code does not fully implement the check.  This code does
     *   not check for all the characters that can be in a localname.  Check
     *   the XML namespace spec for details.
     * </p>
     *
     * @param uri
     * @return
     */
    public static int splitNamespace(String uri)
    {
        char ch;
        if (uri.length() == 0) return 0;
        for (int i=uri.length()-1; i>=0; i--) {
            ch = uri.charAt(i);
            if ( !(   ('a' <= ch && ch <= 'z')  // FIXME: this code does not fully implement the correct test
                    ||('A' <= ch && ch <= 'Z')
                    ||('0' <= ch && ch <= '9')
                    || ch == '-'
                    || ch == '_'
                    || ch == '.'
                    || ch == ':'
                   )
              )
               {
                  // found a character that cannot appear in a localname, so split here
                  return i + 1;
               }
        }
        return 0;
    }
    
    public static String substituteStandardEntities(String s) {        
        s = replace(s, "&", "&amp;");
        s = replace(s, "<", "&lt;");
        s = replace(s, ">", "&gt;");
        s = replace(s, "'", "&apos;");
        return replace(s, "\"", "&quot;");
    }
        
    public static String replace(String s, String oldString, String newString) {
        String result = "";
        int length = oldString.length();
        int pos = s.indexOf(oldString);
        int lastPos = 0;
        while (pos >= 0) {
            result = result + s.substring(lastPos, pos) + newString;
            lastPos = pos + length;
            pos = s.indexOf(oldString, lastPos);
        }
        return result + s.substring(lastPos, s.length());
    }
}
