package Freenet.client.rdf.vocabulary;

import Freenet.client.rdf.util.ErrorHelper;
import Freenet.client.rdf.util.PropertyImpl;
import Freenet.client.rdf.util.ResourceImpl;

import Freenet.client.rdf.Model;
import Freenet.client.rdf.Resource;
import Freenet.client.rdf.Property;
import Freenet.client.rdf.RDFException;

public class DC extends Object
{
    protected static final String uri = "http://purl.org/dc/elements/1.1/";
    
    public static String getURI()
    {
        return uri;
    }    
    
           static final String   ndescription = "description";
    public static       Property description = null;     
           static final String   nsubject = "subject";
    public static       Property subject = null;   
           static final String   ncreator = "creator";
    public static       Property creator = null;   
           static final String   npublisher = "publisher";
    public static       Property publisher = null;   
           static final String   ncontributor = "contributor";
    public static       Property contributor = null;   
           static final String   ndate = "date";
    public static       Property date = null;   
           static final String   ntype = "type";
    public static       Property type = null;   
           static final String   nformat = "format";
    public static       Property format = null;   
           static final String   nidentifier = "identifier";
    public static       Property identifier = null;   
           static final String   nsource = "source";
    public static       Property source = null;   
           static final String   nlanguage = "language";
    public static       Property language = null;   
           static final String   nrelation = "relation";
    public static       Property relation = null;   
           static final String   ncoverage = "coverage";
    public static       Property coverage = null;   
           static final String   nrights = "rights";
    public static       Property rights = null;   
           static final String   ntitle = "title";
    public static       Property title = null;   
    
        
    static {
        try {
            description = new PropertyImpl(uri, ndescription);
            title       = new PropertyImpl(uri, ntitle);
            creator     = new PropertyImpl(uri, ncreator);
            subject     = new PropertyImpl(uri, nsubject);
            publisher   = new PropertyImpl(uri, npublisher);
            contributor = new PropertyImpl(uri, ncontributor);
            date        = new PropertyImpl(uri, ndate);
            type        = new PropertyImpl(uri, ntype);
            format      = new PropertyImpl(uri, nformat);
            identifier  = new PropertyImpl(uri, nidentifier);
            source      = new PropertyImpl(uri, nsource);
            language    = new PropertyImpl(uri, nlanguage);
            relation    = new PropertyImpl(uri, nrelation);
            coverage    = new PropertyImpl(uri, ncoverage);
            rights      = new PropertyImpl(uri, nrights);
        } catch (RDFException e) {
            ErrorHelper.logInternalError("DC", 1, e);
        }
    }
}
