/*
 *  (c) Copyright Hewlett-Packard Company 2000 
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * RDF.java
 *
 * Created on 28 July 2000, 18:12
 */

package Freenet.client.rdf.vocabulary;

import Freenet.client.rdf.util.ErrorHelper;
import Freenet.client.rdf.util.PropertyImpl;
import Freenet.client.rdf.util.ResourceImpl;

import Freenet.client.rdf.Model;
import Freenet.client.rdf.Resource;
import Freenet.client.rdf.Property;
import Freenet.client.rdf.RDFException;

/**
 *
 * @author  bwm
 */
public class RDF{
    
    // next free error code = 2
    
    protected static final String uri =
        "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    
    public static String getURI()
    {
        return uri;
    }
    
    public static       Property li(int i) throws RDFException {
        return new PropertyImpl(uri, "_"+Integer.toString(i));}
    
    
           static final String   nAlt = "Alt";
    public static       Resource Alt = null;    
           static final String   nBag = "Bag";
    public static       Resource Bag = null;    
           static final String   nProperty = "Property";
    public static       Resource Property;
           static final String   nSeq = "Seq";
    public static       Resource Seq = null;
           static final String   nStatement = "Statement";
    public static       Resource Statement = null;
    

           static final String   nsubject = "subject";
    public static       Property subject; 
           static final String   npredicate = "predicate";
    public static       Property predicate;
           static final String   nobject = "object";
    public static       Property object; 
           static final String ntype = "type";
    public static       Property type;
           static final String   nvalue = "value";
    public static       Property value;
   

    
    static {
        try {
            Alt         = new ResourceImpl(uri+nAlt);
            Bag         = new ResourceImpl(uri+nBag);
            Property    = new ResourceImpl(uri + nProperty);
            Seq         = new ResourceImpl(uri+nSeq);
            Statement   = new ResourceImpl(uri+nStatement);
            type        = new PropertyImpl(uri, ntype);
            subject     = new PropertyImpl(uri, nsubject);
            predicate   = new PropertyImpl(uri, npredicate);
            object      = new PropertyImpl(uri, nobject);
            value       = new PropertyImpl(uri, nvalue);

        } catch (RDFException e) {
            ErrorHelper.logInternalError("RDF", 1, e);
        }
    }
    
}
