package Freenet.client.services;
import Freenet.client.*;
import Freenet.*;
import java.io.*;
import java.util.*;
import Freenet.servlet.*;
import Freenet.servlet.util.*;
import Freenet.support.*;

/**
 * Simple Interface for Clients
 *
 * @author Brandon
 **/

public class SIC extends GenericServlet
{
    public SimplifiedClient sc;
    PrintWriter pw;
    BufferedReader in;
    OutputStream out;

    public static void main(String[] args) throws Exception
    {
        SIC sic=new SIC();
        ServletHandler sh=new ServletHandler(new ListeningAddress("tcp/19194"), sic);
        sh.acceptConnections();
    }

    public SIC()
    {
      this(new Params());
    }

    public SIC(Params params)
    {
      sc=new SimplifiedClient(params);
    }

    public Vector makeargs(String path)
    {
      String prefix="", suffix=path;
      int i=-1;
      Vector v=new Vector();

      do
      {
      i=suffix.indexOf(" ");
      if(i==-1)
      {
        prefix=suffix;
        suffix="";
      }
      else
      {
        prefix = suffix.substring(0, i);
        suffix = suffix.substring(i+1);
      }
      v.addElement(prefix);
      } while(i!=-1);
      return v;
    }

    private String[] vtoarr(Vector v)
    {
      String[] arr=new String[v.size()];
      Enumeration iterator=v.elements();
      int x=0;
      while(iterator.hasMoreElements())
      {
        String s=(String)iterator.nextElement();
        arr[x++]=s;
      }
      return arr;
    }

    public void service(ServletRequest req, ServletResponse resp)
    {
      try
      { 
        FreenetServletResponse fsr=(FreenetServletResponse)resp;
        String result;
        pw=resp.getWriter();
        in=req.getReader();
        out=fsr.getNormalOutputStream();

        String s=in.readLine();
        while(s!=null)
        {
          result=handle(pw, s);
          if(result!=null)
          {
            pw.println(result);
            pw.flush();
          }
          s=in.readLine();
        }
      }
      catch(IOException e) {e.printStackTrace(); return;}
    }

    private String handle(PrintWriter pw, String s)
    {
        Vector v=makeargs(s);
        System.out.println("v: "+v);
        String str=(String)v.elementAt(0);
        v.removeElementAt(0);
        String[] arr=vtoarr(v);
        String key=null;
        try { key=arr[0]; } catch(ArrayIndexOutOfBoundsException e) {}
        String filename=null;
        try { filename=arr[1]; } catch(ArrayIndexOutOfBoundsException e) {}
        String metaFilename=null;
        try { metaFilename=arr[2]; } catch(ArrayIndexOutOfBoundsException e) {}
        System.out.println("str: "+str);
        if(str.equals("insert"))
        {
          try
          {
            sc.put(key, filename, metaFilename);
          }
          catch(Exception e)
          { return "EXCEPTION: "+e; }
          return "OK";
        }
        if(str.equals("request"))
        {
          try
          {
            if(filename==null && metaFilename==null)
            {
              Pair p = sc.get(key);
              if(p==null) return "ERROR";
              Bucket meta = (Bucket)p.first;
              Bucket file = (Bucket)p.last;
              pw.println("OK");
              pw.println("Content-Length: "+file.size());
              pw.flush();
              Conduit c=new Conduit(file.getInputStream(), out, null);
              c.run();
            }
            else
              sc.get(key, filename, metaFilename);
          }
          catch(Exception e)
          { e.printStackTrace(); return "EXCEPTION: "+e; }
          return "OK";
        }
        return "UNDEFINED";
    }
}
