package FCP;

$DEBUG = 1;
$BUFSIZE = 10240;
BEGIN {
    use strict;
    use Carp qw(cluck croak);
    use IO::Socket;
    use IO::File;

    use Exporter ();
    use vars     qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);

    # if using RCS/CVS, this next line may be preferred,
    # but beware two-digit versions.
    $VERSION = do{my@r=q$Revision: 1.18.2.1 $=~/\d+/g;sprintf '%d.'.'%02d'x$#r,@r};
    
    @ISA         = qw(Exporter);
    @EXPORT      = qw(&init &getURI &putURI &parseComField &printField &stringPCF);
    %EXPORT_TAGS = ( );     # eg: TAG => [ qw!name1 name2! ],
    
    # your exported package globals go here,
    # as well as any optionally exported functions
    @EXPORT_OK   = qw($response %fields);
}
use vars      @EXPORT_OK;

# non-exported package globals go here
use vars      qw($SERVER $PORT $PROTOCOL $NODETYPE $REDIRECTOK);

# initialize package globals, first exported ones
$response = "";
%fields = ();

# then the others (which are still accessible as $Some::Module::stuff)
$SERVER = "localhost";
$PORT = 3125;
$PROTOCOL = 1;
$NODETYPE = "";

# all file-scoped lexicals must be created before
# the functions below that use them.

# file-private lexicals go here

# here's a file-private function as a closure,
# callable as &$priv_func;  it cannot be prototyped.
#my $priv_func = sub {
#    # stuff goes here.
#};

# make all your functions, whether exported or not;
# remember to put something interesting in the {} stubs

#initializes the setup; handshakes the node and sets up globals
sub init ($$) {
    @_ == 2 or croak 'usage Init(SERVER, PORT)';
    $SERVER = shift;
    $PORT = shift;
    my $serfh = &connectToServer;
    &printField($serfh, "ClientHello", {});
    my $fields;
    ($response, $fields) = &parseComField($serfh);
    %fields = %$fields;
    &closeServer($serfh);
    $PROTOCOL = $fields->{Protocol};
    $NODETYPE = $fields->{Node};
}

#gets a URI
sub getURI ($$$) {
    @_ == 3 || @_ == 4 or 
	croak 'usage: GetURI(URI, HTL, [METAWHERE, DATAWHERE]|PROCFUNC)';
    my $uri = shift;
    my $htl = shift;
    if (@_ == 1) {  #if there's only one argument left
	my $dcfunc = shift;
	croak "PROCFUNC must be a function reference" 
	    unless ref $dcfunc eq "CODE";
	my $serfh = &connectToServer;
	&printField($serfh, "ClientGet", {URI => $uri, HopsToLive => $htl});
	my ($dread, $dsize, $waiting, $fields) = (0, 1, 1, {});
	while ($dread < $dsize) {
	    ($_, $fields) = &parseComField($serfh);
	    $waiting and do {
		/^DataFound$/ and do {$dsize = hex $fields->{DataLength};
				      $waiting = 0; &$dcfunc($_, $fields);
				      next };
		/^Restarted$/ and next;
		/^DataNotFound$/ and do {&$dcfunc($_, $fields); return 0 };
		/^RouteNotFound$/ and do {&$dcfunc($_, $fields); return 0 };
		die "Got Message $_ while waiting";
	    };
	    /^DataChunk$/ and do {$dread += hex $fields->{Length}; 
				  &$dcfunc($_, $fields); next};
	    /^Restarted$/ and do {&$dcfunc("Rewind", { Length => $dread }); 
				  $dread = 0; $waiting = 1; next};
	    die "Got message $_ while not waiting";
	}
	return 1;
    }
    my $mwhere = shift;
    croak 'METAWHERE must be a scalar reference or IO::File'
	unless ref $mwhere eq "SCALAR" or ref $mwhere eq "IO::File";
    my $mscalar = ref $mwhere eq "SCALAR";
    my $mfile = ref $mwhere eq "IO::File";
    $$mwhere = "" if $mscalar;
    my $dwhere = shift;
    croak "DATAWHERE must be a scalar reference or IO::File, is a " . (ref $dwhere) . " reference"
	unless ref $dwhere eq "SCALAR" or ref $dwhere eq "IO::File";
    my $dscalar = ref $dwhere eq "SCALAR";
    my $dfile = ref $dwhere eq "IO::File";
    $$dwhere = "" if $dscalar;
    my $serfh = &connectToServer;
    &printField($serfh, "ClientGet", {URI => $uri, HopsToLive => $htl});
    my ($dread, $mread) = (0,0);
  WAITING:
    my ($fields, $dsize, $msize);
    ($response, $fields) = &parseComField($serfh);
    %fields = %$fields;
    for ($response) {
	/^Restarted$/ and goto WAITING;
	/^DataFound$/ or do { &closeServer($serfh); return 0 };
    }
    #$response must be DataFound
    $msize = 0;
    $msize = hex $fields{MetadataLength} if defined $fields{MetadataLength};
    $dsize = hex $fields{DataLength};
    $dsize -= $msize;  #datalength includes metadatalength
    #have to start over if we've read stuff before
    $mread = 0;
    $dread = 0;
    my $databuffer = "";
    my $bufsize = 0;
    print STDERR "Meta: $msize  Data: $dsize\n" if $DEBUG;
    while ($msize > $mread) {
	($response, $fields) = &parseComField($serfh);
	die "Not recieving enough data" unless $fields->{Length};
	if ($response eq "Restarted") {
	    seek ($mwhere, -$mread, 1) if $mfile;
	    substr $$mwhere, -$mread, $mread, "" if $mscalar;
	    goto WAITING;
	}
	my $databuffer = $fields->{Data};
	my $bufsize = length $databuffer;
	my $bufout = $bufsize > $msize - $mread ?
	    $databuffer : substr $databuffer, 0, $msize-$mread, "";
	$bufsize -= length $bufout;
	$mread += length $bufout;
	$$mwhere .= $bufout if $mscalar;
	print $mwhere $bufout if $mfile;
	print STDERR ".";
    }
    while ($dsize > $dread) {
	($response, $fields) = &parseComField($serfh);
	die "Not recieving enough data" unless $fields->{Length};
	if ($response eq "Restarted") {
	    seek ($mwhere, -$mread, 1) if $mfile;
	    substr $$mwhere, -$mread, $mread, "" if $mscalar;
	    seek ($dwhere, -$dread, 1) if $dfile;
	    substr $$dwhere, -$dread, $dread, "" if $dscalar;
	    &$dwhere($response, $fields) if $dcode && $dread;
	    goto WAITING;
	}
	my $databuffer = $fields->{Data};
	$bufsize -= length $databuffer;
	$dread += length $databuffer;
	$$dwhere .= $databuffer if $dscalar;
	print $dwhere $databuffer if $dfile;
	print STDERR ".";
    }
    &closeServer($serfh);
    die "Too much data read" if $dread > $dsize;
    return 1;
}

#puts a URI
sub putURI {
    @_ == 4 || @_ == 5 
	or croak 'usage: PutURI(URI, HTL, METADATA, DATA [,TOTALENGTH])';
    my $uri = shift;
    my $htl = shift;
    croak "HTL must be a number" unless $htl =~ /\d+/;
    my $metadata = shift || "";
    croak 'METADATA must be a scalar' unless ref \$metadata eq "SCALAR";
    my $data = shift;
    croak 'DATA must be a scalar or IO::File'
	unless ref \$data eq "SCALAR" or ref $data eq "IO::File";
    my $file = ref $data eq "IO::File";
    my $totalength = shift;
    if (! defined $totalength) {
	croak 'Must pass in TOTALENGTH if DATA is an IO::File' 
	    if ref $data eq "IO::File";
	$totalength = (length $metadata) + (length $data);
    }
    my $metalength = length $metadata;

    my $serfh = &connectToServer;
    my $message = sprintf "ClientPut\nHopsToLive=%x\nURI=$uri\nDataLength=%x\nMetadataLength=%x\nData\n", $htl, $totalength, $metalength;
    print $serfh $message;
#    print STDERR $message if $DEBUG;
    my $len = 0;
    print $serfh $metadata;
    $len += length $metadata;
    if ($file) {
	while (read $data, $_, $BUFSIZE) {
	    $len += length $_;
	    print $serfh $_;
	}
    } else {
	$len += length $data;
	print $serfh $data;
    }

    my $fields;
    do {
	($response, $fields) = &parseComField($serfh);
    } while ($response eq "Restarted");
    %fields = %$fields;
#    return 0 unless $response eq "Success";
    return $fields{URI};
}

sub printField ($$$) {
    my $fh = shift;
    my $command = shift;
    my $fields = shift;
    
    print $fh "$command\n";
    print STDERR "SENDING:\n$command\n" if $DEBUG & 2;
    for my $key (keys %$fields) {
	next if $key eq "Data";
	print $fh "$key=" . $fields->{$key} . "\n" if $key;
	print STDERR "$key=" . $fields->{$key} . "\n" if $DEBUG & 2;
    }
    if ($fields->{Data}) {
	print $fh "Data\n";
	print $fh $fields->{Data};
	print STDERR "Data\n" if $DEBUG & 2;
    } else {
	print $fh "EndMessage\n";
	print STDERR "EndMessage\n" if $DEBUG & 2;
    }
}

sub parseComField ($) {
    my $fh = shift;
    print STDERR "PARSING:\n" if $DEBUG & 2;
    my $command = <$fh>;
    return ("", {}) unless defined $command;
    chomp $command;
    print STDERR "$command\n" if $DEBUG & 2;
    my %fields = ();
    while (<$fh>) {
	chomp;
	last if /^EndMessage$/;
	last if /^Data$/;
	print STDERR "got: <$_>\n" if $DEBUG & 2;
	my ($key,$value) = split /=/;
	next unless defined $key;
	next unless defined $value;
	$fields{$key} = $value;
    }
    if ($_ eq "Data") {
	my $len = hex ($fields{Length} || $fields{DataLength});
	print STDERR "ChunkLength: $len\n" if $DEBUG & 2;
	read $fh, $fields{Data}, $len;
	print STDERR "GOT: ", length $fields{Data}, "\n" if $DEBUG & 2;
    }
    print STDERR "Parsed: $command -> ", join ",", keys %fields, "$_\n" if $DEBUG & 2;
    return ($command,\%fields);
}

sub connectToServer {
    my $port    = shift || $PORT;  # random port
    my $remote  = shift || $SERVER;

    if ($port =~ /\D/) { $port = getservbyname($port, 'tcp') }
    die "No port" unless $port;
    my $sock = IO::Socket::INET->new("$remote:$port") || die "couldn't connect to server tcp/$remote:$port";
    print $sock pack ("c4", 0, 0, 0, 2);
    return $sock;
}

sub closeServer {
    my $socket = shift;
    close $socket;
}

sub stringPCF ($) {
    my $ptr = shift;
    return (undef, {}) unless $$ptr =~ /\nEndMessage\n/ || $$ptr =~ /\nData\n/;
    $_ = $$ptr;
    print STDERR "PARSING:\n" if $DEBUG & 2;
    my $command;
    ($command, $_) = split /\n/, $_, 2;
    print STDERR "$command\n" if $DEBUG & 2;
    $$ptr = $_, return (undef, {}) unless defined $command;
    my %fields = ();
    my $line;
    ($line, $_) = split /\n/, $_, 2;
    while ( $line ) {
	print STDERR "got: <$line>\n" if $DEBUG & 2;
	last if $line eq "EndMessage";
	last if $line eq "Data";
	$$ptr = $_, return (undef, {}) unless $line =~ /^[\w\d\s]+=[\w\d\s]+/;
	my ($key, $value) = split /=/, $line, 2;
	next unless defined $key;
	next unless defined $value;
	$fields{$key} = $value;
	($line, $_) = split /\n/, $_, 2;
    }
    $$ptr = $_, return (undef, {}) unless $line;
    if ($line eq "Data") {
	my $len = hex ($fields{Length} || $fields{DataLength});
	die "Data without Length" if (!defined $len);
	print STDERR "ChunkLength: $len\n" if $DEBUG & 2;
	$fields{Data} = substr $_, 0, $len, "";
	print STDERR "GOT: ", length $fields{Data}, "\n" if $DEBUG & 2;
	do {print STDERR "B"; return (undef, {})} unless length $fields{Data} == $len;
    }
    $$ptr = $_;  #replace the buffer with what's left after parsing
    print STDERR "Parsed: $command -> ", join ",", keys %fields, "$_\n" if $DEBUG & 2;
    return ($command,\%fields);
}

END { }

1;
