package FCP2;

$DEBUG = 1;
$BUFSIZE = 10240;
BEGIN {
    use strict;
    use Carp qw(cluck croak);
    use IO::Socket;
    use IO::File;

    use Exporter ();
    use vars     qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);

    # if using RCS/CVS, this next line may be preferred,
    # but beware two-digit versions.
    $VERSION = do{my@r=q$Revision: 1.3.2.1 $=~/\d+/g;sprintf '%d.'.'%02d'x$#r,@r};
    
    @ISA         = qw(Exporter);
    @EXPORT      = qw(&init &getURI &putURI &parseComField &printField);
    %EXPORT_TAGS = ( );     # eg: TAG => [ qw!name1 name2! ],
    
    # your exported package globals go here,
    # as well as any optionally exported functions
    @EXPORT_OK   = qw($response %fields);
}
use vars      @EXPORT_OK;

# non-exported package globals go here
use vars      qw($SERVER $PORT $PROTOCOL $NODETYPE $REDIRECTOK);

# initialize package globals, first exported ones
$response = "";
%fields = ();

# then the others (which are still accessible as $Some::Module::stuff)
$SERVER = "localhost";
$PORT = 3125;
$PROTOCOL = 1;
$NODETYPE = "";

# all file-scoped lexicals must be created before
# the functions below that use them.

# file-private lexicals go here

# here's a file-private function as a closure,
# callable as &$priv_func;  it cannot be prototyped.
#my $priv_func = sub {
#    # stuff goes here.
#};

# make all your functions, whether exported or not;
# remember to put something interesting in the {} stubs

#initializes the setup; handshakes the node and sets up globals
sub init ($$) {
    @_ == 2 or croak 'usage Init(SERVER, PORT)';
    $SERVER = shift;
    $PORT = shift;
    &connectToServer or return 0;;
    &printField("ClientHello", {});
    my $fields;
    ($response, $fields) = &parseComField;
    %fields = %$fields;
    $PROTOCOL = $fields->{Protocol};
    $NODETYPE = $fields->{Node};
    return 1;
}

#gets a URI
sub getURI ($$$) {
    @_ == 3 || @_ == 4 or 
	croak 'usage: GetURI(URI, HTL, METAWHERE, DATAWHERE)';
    my $uri = shift;
    my $htl = shift;
    my $mwhere = shift;
    croak 'METAWHERE must be a scalar reference or IO::File'
	unless ref $mwhere eq "SCALAR" or ref $mwhere eq "IO::File";
    my $mscalar = ref $mwhere eq "SCALAR";
    my $mfile = ref $mwhere eq "IO::File";
    $$mwhere = "" if $mscalar;
    my $dwhere = shift;
    croak "DATAWHERE must be a scalar reference or IO::File, is a " . (ref $dwhere) . " reference"
	unless ref $dwhere eq "SCALAR" or ref $dwhere eq "IO::File";
    my $dscalar = ref $dwhere eq "SCALAR";
    my $dfile = ref $dwhere eq "IO::File";
    $$dwhere = "" if $dscalar;
    &printField("ClientGet", {URI => $uri, HopsToLive => $htl});
    my ($dread, $mread) = (0,0);
  WAITING:
    my ($fields, $dsize, $msize);
    ($response, $fields) = &parseComField;
    %fields = %$fields;
    for ($response) {
	/^DataFound$/ or do { return 0 };
    }
    #$response must be DataFound
    if ($fields{MetadataLength}) {
	$msize = hex $fields{MetadataLength};
    } else {
	$msize = 0;
    }
    $dsize = hex $fields{DataLength};
    $dsize -= $msize;
    #have to start over if we've read stuff before
    $mread = 0;
    $dread = 0;
    my $sprint = 0;
    print STDERR "Meta: $msize  Data: $dsize\n" if $DEBUG;
  META:
    while ($msize > $mread) {
	($response, $fields) = &parseComField;
	die "Not recieving enough data" unless $fields->{Length};
	if ($response eq "Rewind") {
	    my $howmuch = $fields->{Length};
	    seek ($mwhere, -$howmuch, 1) if $mfile;
	    substr $$mwhere, -$howmuch, $howmuch, "" if $mscalar;
	    next;
	}
	my $databuffer = $fields->{Data};
	my $bufsize = length $databuffer;
	my $bufout = $bufsize > $msize - $mread ?
	    $databuffer : substr $databuffer, 0, $msize-$mread, "";
	$bufsize -= length $bufout;
	$mread += length $bufout;
	$$mwhere .= $bufout if $mscalar;
	print $mwhere $bufout if $mfile;
	$sprint+=64*1024, print STDERR "Recieved $sprint/$msize bytes\n" 
	    if $mread > $sprint + 64*1024;
    }
    print STDERR "Recieved $mread bytes of metadata\n";
    $sprint = 0;
    while ($dsize > $dread) {
	($response, $fields) = &parseComField;
	if ($response eq "Rewind") {
	    my $howmuch = $fields->{Length};
	    if ($howmuch > $dread) {
		seek ($mwhere, -$mread, 1) if $mfile;
		substr $$mwhere, -$mread, $mread, "" if $mscalar;
		seek ($dwhere, -$howmuch + $mread, 1) if $dfile;
		substr $$dwhere, -$howmuch + $mread, $howmuch - $mread, "" if $dscalar;
		goto META;
	    } else {
		seek ($dwhere, -$dread, 1) if $dfile;
		substr $$dwhere, -$dread, $dread, "" if $dscalar;
		next;
	    }
	} elsif ($response eq "DataChunk") {
	    die "Not recieving enough data" unless $fields->{Length};
	    my $databuffer = $fields->{Data};
	    my $bufsize -= length $databuffer;
	    $dread += length $databuffer;
	    $$dwhere .= $databuffer if $dscalar;
	    print $dwhere $databuffer if $dfile;
	    $sprint+=64*1024, print STDERR "Recieved $sprint/$dsize bytes\n" 
		if $dread > $sprint + 64*1024;
	} elsif ($response eq "DataNotFound") {
	    my $missing = $fields->{Missing};
	    print STDERR "Cannot retrieve piece: $missing\n";
	    last;
	} else {
	    die "Got message $response when expecting data";
	}
    }
    print STDERR "Recieved $dread bytes of data\n";
    die "Too much data read" if $dread > $dsize;
    return 1;
}

#puts a URI
sub putURI {
    @_ == 4 || @_ == 5 
	or croak 'usage: PutURI(URI, HTL, METADATA, DATA [,TOTALENGTH])';
    my $uri = shift;
    my $htl = shift;
    croak "HTL must be a number" unless $htl =~ /\d+/;
    my $metadata = shift;
    croak 'METADATA must be a scalar' unless ref \$metadata eq "SCALAR";
    my $data = shift;
    croak 'DATA must be a scalar or IO::File'
	unless ref \$data eq "SCALAR" or ref $data eq "IO::File";
    my $file = ref $data eq "IO::File";
    my $totalength = shift;
    my $datacontent = "";
    if ($file) { 
	$datacontent .= $_ while <$data>; 
    } else { 
	$datacontent = $data; 
    }
    
    $totalength = length $datacontent unless defined $totalength;
    my $metalength = length $metadata || 0;
    $totalength += $metalength;

    printField("ClientPut",
	       { HopsToLive => (sprintf "%x", $htl),
		 URI => $uri,
		 DataLength => (sprintf "%x", $totalength),
		 MetadataLength => (sprintf "%x", $metalength),
		 Data => $metadata . $datacontent} );

    my $fields;
    ($response, $fields) = &parseComField;
    %fields = %$fields;

    return $fields{URI};
}

sub printField ($$) {
    my $command = shift;
    my $fields = shift;
    
    print SOCK "$command\n";
    print STDERR "SENDING:\n$command\n" if $DEBUG & 2;
    for my $key (keys %$fields) {
	next if $key eq "Data";
	print SOCK "$key=" . $fields->{$key} . "\n" if $key;
	print STDERR "$key=" . $fields->{$key} . "\n" if $DEBUG & 2;
    }
    if ($fields->{Data}) {
	print SOCK "Data\n";
	print SOCK $fields->{Data};
	print STDERR "Data\n" if $DEBUG & 2;
    } else {
	print SOCK "EndMessage\n";
	print STDERR "EndMessage\n" if $DEBUG & 2;
    }
}

sub parseComField {
    print STDERR "PARSING:\n" if $DEBUG & 2;
    my $command = <SOCK>;
    chomp $command;
    print STDERR "$command\n" if $DEBUG & 2;
    my %fields = ();
    while (<SOCK>) {
	chomp;
	last if /^EndMessage$/;
	last if /^Data$/;
	print STDERR "got: <$_>\n" if $DEBUG & 2;
	my ($key,$value) = split /=/;
	next unless defined $key;
	next unless defined $value;
	$fields{$key} = $value;
    }
    if ($_ eq "Data") {
	my $len = hex ($fields{Length} || $fields{DataLength});
	print STDERR "ChunkLength: $len\n" if $DEBUG & 2;
	read SOCK, $fields{Data}, $len;
	print STDERR "GOT: ", length $fields{Data}, "\n" if $DEBUG & 2;
    }
    print STDERR "Parsed: $command -> ", join ",", keys %fields, "$_\n" if $DEBUG & 2;
    return ($command,\%fields);
}

sub connectToServer {
    my $port    = shift || $PORT;  # random port
    my $remote  = shift || $SERVER;

    if ($port =~ /\D/) { $port = getservbyname($port, 'tcp') }
    die "No port" unless $port;
    my $iaddr   = inet_aton($remote)               || die "no host: $remote";
    my $paddr   = sockaddr_in($port, $iaddr);
    
    my $proto   = getprotobyname('tcp');
    socket(SOCK, PF_INET, SOCK_STREAM, $proto)  || die "socket: $!";
    connect(SOCK, $paddr)    || die "connect: $!";
    select (SOCK); $| = 1; select (STDOUT);
    print SOCK pack ("c4", 0, 0, 0, 2);
    return *SOCK;
}

sub closeServer {
    close SOCK;
}


END { printField("CloseConnection", {}); close SOCK; }

1;
