#!/usr/bin/perl -w

use strict;
use File::Find;
use IO::File;
use FCP2;

my $SERVER = 'localhost';
my $PORT = 7892;
my $URI;
my $HTL = 20;
my $directory = ".";

my @nextargv;
for (@ARGV) {
    /^--help$/     and do { &usage; exit 1 };
    /^--htl$/      and do { push @nextargv, \$HTL; next };
    /^--directory$/ and do { push @nextargv, \$directory; next };
    /^-(.*)$/ and do {foreach (split //, $1) {
	/[\?]/ and do { &usage; exit 1 };
	/h/ and do {push @nextargv, \$HTL; next };
	/p/ and do {push @nextargv, \$PORT; next };
	/d/ and do {push @nextargv, \$directory; next };
	die "$0: unknown option\"-$1\", check usage with --help\n"; } next };
    @nextargv and do {my $r = shift @nextargv; $r and $$r = $_; next };
    !$URI and do {$URI = $_; next};
    die "$0: Too many arguments, check usage with $0 --help";
}
die "No URI" unless $URI;
&init($SERVER, $PORT);

my $metadata = "Version\nVersionNo=0\n";
&find ({ wanted => \&process, follow => 1, no_chdir => 1}, $directory);
$metadata .= "End\n";

my $OUT = &putURI($URI, $HTL, $metadata, "");
print $metadata;
print "Inserted as $OUT";

sub process {
    my $name = $_;
    return unless -f $_ || -l $_;
    return unless -s $_;  #no inserting 0 size files
    my $file = IO::File->new($_);
    $name =~ s|^$directory/||;
    print "Inserting $name\n";
    my $URI = &putURI("CHK@", $HTL, "", $file);
    print "URI=$URI\n";
    $metadata .= "EndPart\nRedirect\nDocumentName=$name\nTarget=$URI\n" if $URI;
    close $file;
}
