#!/usr/bin/perl -w

use strict;
use FCP2;
use IO::File;

my $MODE = "request";
my $URI = "";
my $HTL = 20;
my $METAOUT = new IO::File ">&STDOUT";
my $DATAOUT;
my $SERVER = "localhost";
my $PORT = 7892;
my $METADATAFILE = "";
my $VERB = 1;
my $key;
my $filename;

sub usage {
    print "$0 version 0.something
Copyright (C) 2001 Eric Norige
This is free software and may be redistributed under the terms of the GNU GPL.

usage: $0 [options] [URI] [filename]
  --help             - print this help message
  --htl (-h)         - set the HTL of the request/insert
  --insert <URI> (-i)- insert into a particular key
  --request <URI>(-r)- request a key (default mode)
  -p <n>             - set the FCP2 port to connect to
  -m <filename>      - write the metadata to a file
";
}


my @nextargv;
for (@ARGV) {
    /^--help$/     and do { &usage; exit 1 };
    /^--htl$/      and do { push @nextargv, \$HTL; next };
    /^--metadata$/ and do { push @nextargv, \$METADATAFILE; next };
    /^--insert$/   and do { $MODE = "insert"; push @nextargv, \$key; next };
    /^--request$/  and do { $MODE = "request";  push @nextargv, \$key; next };
    /^-(.*)$/ and do {foreach (split //, $1) {
	/[\?]/ and do { &usage; exit 1 };
	/h/ and do {push @nextargv, \$HTL; next };
	/p/ and do {push @nextargv, \$PORT; next };
	/m/ and do {push @nextargv, \$METADATAFILE; next };
	/v/ and do {$VERB++; next };  #fix me
	/q/ and do {$VERB--; next };  #fix me
	/i/ and do {$MODE="insert"; push @nextargv, \$key; next };
	/r/ and do {$MODE="request"; push @nextargv, \$key; next };
	die "$0: unknown option\"-$1\", check usage with --help\n"; } next };
    @nextargv and do {my $r = shift @nextargv; $r and $$r = $_; next };
    !$key and do {$key = $_; next};
    !$filename and do {$filename = $_; next };
    die "$0: Too many arguments, check usage with $0 --help";
}
die "$0: Must input a key" unless $key;
$filename = $1 if $key =~ /\/\/(.*)/ && !defined $filename;
$filename = $key if $key !~ /@/ && !defined $filename;
$filename = $1 if $key =~ /KSK@.*\/(.*)/ && !defined $filename;
$filename = $1 if $key =~ /CHK@[^\/]*\/(.*)/ && !defined $filename;
die "$0: Must give a filename" unless $filename;

&init($SERVER, $PORT) or die "Can't connect to $SERVER:$PORT";
if ($MODE ne "insert") {
    my $datafile = new IO::File ">$filename";
    print "Sending output to $filename\n" if $VERB > 0;
    &getURI($key, $HTL, $METAOUT, $datafile);
} elsif ($MODE eq "insert") {
    my $datalen = -s $filename;
#    die "Datafile must have content" unless $datalen;
    my $datafile = new IO::File $filename;
    my $metadata = "";
    if ($METADATAFILE) {
	open META, $METADATAFILE or die "cannot open $METADATAFILE: $!";
	$metadata .= $_ while (<META>);
	close META;
    }
    $datalen += length $metadata;
    print "Inserting $filename\n" if $VERB > 0;
    &putURI($key, $HTL, $metadata, $datafile, $datalen);
    close $datafile;
    unlink $filename unless -s $filename;
}
if ($FCP2::response ne "DataChunk" && $VERB > 0) {
    print "\n", $FCP2::response, "\n";
    foreach (keys %FCP2::fields) {
	next if /^Data$/;
	print "$_ = ", $FCP2::fields{$_}, "\n";
    }
}
