package Freenet.contrib.attacks;

import Freenet.*;
import Freenet.message.*;
import Freenet.node.*;
import Freenet.support.*;
import Freenet.support.io.*;
import java.io.*;
import java.util.Vector;
import java.util.Enumeration;

/**
 * A dishonest Cancer is a node that replies to all DataRequests with false
 * data. This attack used to be a big concern, but is largely solved as of
 * Freenet 0.3 by the cryptographically verifying keys, and this is simply
 * used to test that detection of bad data works smoothly.
 *
 * This cancer will be revealed already when checking the the Signature on
 * all SVKs, CHKs, and all SSKs except "freenet:KSK@lala", and after the first
 * part on CHKs.
 *
 * This attack is in the form a DataStore that can be plugged into the node
 * instead of the StandardDataStore.
 *
 * @author oskar
 **/


public class Cancer implements DataStore {

    static {
	System.err.println("THIS NODE IS RUNNING A MODIFIED DATASTORE THAT MAKES IT GIVE OFF FALSE RESPONSES. THIS IS ONLY MEANT FOR TESTING, SO DON'T USE IT IF YOU DON'T KNOW WHAT YOU ARE DOING (and no, you there with the roll of cash from the censorship industry, this is not an effective attack either. While your waiting to those sedatives to kick in, maybe you should take some time to consider what you are doing with your short time here on earth...)");
    }

    public static void main(String[] args) {
	Node.run = false;
	Node.main(args);
	Node.n.ds = new Cancer();
	Node.n.acceptConnections(new StandardMessageHandler(Node.n,100));
    }

    public Cancer() {
    }

    public void tofile(String filename) {
	return;
    }

    public void callback() {
	return;
    }

    public Entity searchData(Key k) {
	return new CancerEntity();
    }

    public NodeReference searchRef(Key k) {
	try {
	    return new NodeReference("tcp","you_are_cancered");
	} catch (IllegalArgumentException e) {
	    Core.logger.log(this,e.toString(),Logger.ERROR);
	    return null;
	}
    }

    public void remove(Key k) {
	return;
    }

    public void removeRef(Key k) {
	return;
    }

    public Key findClosestKey(Key k) {
	return null;
    }

    public Key findClosestKey(Key k, Key maskKey) {
	return null;
    }

    public void put(Key k, NodeReference r, Entity d) {
	return;
    }

    public Entity newEntity(SplitOutputStream datatunnel, long dataLength,
			    long partLength) {
	return new CancerEntity();
    }

    private class CancerEntity extends Entity {

	public CancerEntity() {
	    super();
	    data = new CancerData();
	    props = new CancerDataProperties();
	}

	public void write(DataOutputStream dos) {
	    return;
	}

	public void write(FieldSet fs) {
	    return;
	}
    }

    private class CancerDataProperties extends DataProperties {

	public boolean isSaved = false;

	public CancerDataProperties() {
	}

	public void store(FieldSet fs) {
	    isSaved = true;
	}

	public FieldSet restore() {
	    FieldSet fs = new FieldSet();    
	    fs.add("PartSize","1010");
	    fs.add("Public-key","497A63F24254FFF79F23AAE3C166A305F07136A5D38201BCBBC394E121FEB404D26F4F6BFB73D9ABC6D713CC1FDA6571D8555BC2EDD8E882F92370EBE9358CEB465A6B23A3D8AC61A17BF90C1DF7318D0ACE7B068CDF7DF008FBD5F2259129F96F85BED1ADAB73018B242D154D826E7682FED65B5BC8DFF722DE010E358EEE67");
	    fs.add("Signature","5945C29CBBF6F230EABC401CDA8FD8785E5FDFC7,9DC37245D16568D3D9169F4EBE4EA955CE55ABCB");

	    return fs;
	}

	public long length() {
	    return 0;
	}

	public void delete() throws IOException {
	}

	public boolean isSaved() {
	    return isSaved;
	}
    }


    private class CancerData implements Data {

	private Vector readers = new Vector();

	public CancerData() {
	}

	public boolean isReadable() {
	    return true;
	}

	public long getLength() {
	    return 0x10000;
	}

	public ControlInputStream getInputStream() {
	    ControlInputStream cis = new 
		ControlInputStream(new CancerInputStream(),(long) 0xFFFF,
				   getLength());
	    readers.addElement(cis);
	    return cis;
	}

	public void stop() {
	    return;
	}

	public void stopStreams(int endChar) {
	    for (Enumeration e = readers.elements() ; e.hasMoreElements() ;) {
		ControlInputStream cis = (ControlInputStream) e.nextElement();
		cis.endWithNextControl(endChar);
	    }
	}

	private class CancerInputStream extends InputStream {

	    private long read;

	    public CancerInputStream() {
	    }

	    public int read() {
		if (read < getLength() - 1) {
		    read++;
		    return 0;
		} else if (read == getLength() - 1) {
		    readers.remove(this);
		    read++;
		    return Presentation.CB_OK;
		} else
		    return -1;
	    }

	    public void close() {
		readers.remove(this);
	    }
	}
    }
}





