#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/errno.h>
#include <ctype.h>
#include <fcntl.h>

FILE *
fcp_connect ()
{
    struct in_addr addr;
    struct sockaddr_in address;
    struct servent *serv;
    int connected_socket, connected;
    serv = getservbyname("fcp", "tcp");
    if (!serv) return NULL;
    addr.s_addr = inet_addr("127.0.0.1");
    memset((char *) &address, 0, sizeof(address));
    address.sin_family = AF_INET;
    address.sin_port = (serv->s_port);
    address.sin_addr.s_addr = addr.s_addr;
    connected_socket = socket(AF_INET, SOCK_STREAM, 0);
    connected = connect(connected_socket, (struct sockaddr *) &address, sizeof(address));
    if (connected < 0) return NULL;
    return fdopen(connected_socket, "w+");
}

int
fcp_redirect (char *uri, FILE *mdata)
{
    int status;
    status = fscanf(mdata, "Redirect\nEnd\n%s", uri);
    if (status < 0) return 1;
    if (strncmp(uri, "freenet:", 8) != 0) return 1;
    return 0;
}

void
fcp_get (char *uri, int fd)
{
    char line[128], ruri[256];
    int status, mlen = 0, len = 0, c;
    FILE *sock = fcp_connect(), *temp = tmpfile();
    if (!sock || !temp) goto connectfail;

    fprintf(sock, "ClientGet\nURI=%s\nHopsToLive=%x\nEndMessage\n", uri, 10);
    fgets(line, 128, sock);
    if (strncmp(line, "DataFound", 9) != 0) goto requestfail;
    for (c = 0 ; c < 2 ; c++) {
	fgets(line, 128, sock);
	sscanf(line, "MetadataLength=%x", &mlen);
	sscanf(line, "DataLength=%x", &len);
    }
    fgets(line, 128, sock);
    if (strncmp(line, "EndMessage", 10) != 0) goto readfail;
    if (len <= 0 || mlen < 0) goto readfail;
    
    len -= mlen;
    while (mlen > 0) {
	fscanf(sock, "DataChunk\nLength=%x\nData", &status);
	fgetc(sock);
	if (status <= 0) goto readfail;
	while (status--) {
	    c = fgetc(sock);
	    if (c == EOF) goto readfail;
	    if (mlen-- < 0) write(fd, &c, 1);
	    else fputc(c, temp);
	}
    }
    len += mlen;

    rewind(temp);
    if (fcp_redirect(ruri, temp) == 0) {
	fprintf(stderr, "Redirecting to %s ...\n", ruri);
	return fcp_get(ruri, fd);
    }
    
    while (len > 0) {
	fscanf(sock, "DataChunk\nLength=%x\nData", &status);
	if (status <= 0) goto readfail;
	fgetc(sock);
	len -= status;
	while (status--) {
	    c = fgetc(sock);
	    if (c == EOF) goto readfail;
	    write(fd, &c, 1);
	}
    }
    
    return;

connectfail:
    fprintf(stderr, "Connection to Freenet node failed.\n");
    return;
requestfail:
    fprintf(stderr, "Freenet request failed.\n");
    return;
readfail:
    fprintf(stderr, "Freenet input/output failed. (I/O or message format error)\n");
    return;
}

int
main (int argc, char **argv)
{
    int fd;
    if (argc != 3) {
	printf("Usage: %s URI outfile\n", argv[0]);
	return 1;
    }
    fd = open(argv[2], O_RDWR | O_CREAT | O_TRUNC, 0644);
    if (fd < 0) {
	printf("Can't open %s for writing!\n", argv[2]);
	return 1;
    }
    fcp_get(argv[1], fd);
    return 0;
}

