package Freenet.contrib.fproxy;

import Freenet.*;
import Freenet.client.*;
import Freenet.crypt.*;
import Freenet.keys.*;
import Freenet.message.*;
import Freenet.support.*;
import Freenet.support.io.*;
import java.io.*;
import java.math.*;
import java.net.*;
import java.util.*;
import Freenet.client.NoDataException;

/*
  This code is part of fproxy, an HTTP proxy server for Freenet.
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/


/**
 * Wrapper to send Freenet requests on behalf of the HttpHandler
 * (Confusingly, this is not a "client" of the ProxyServer, but
 * rather a variety of Freenet client (a la InsertClient, RequestClient).
 *
 * @author <a href="http://www.doc.ic.ac.uk/~twh1/">Theodore Hong</a>
 **/

public class ProxyClient
{
    private OutputStream out;
    private static final int defaultListenPort = 0;
    private SimplifiedClient sc;


    /**
     * Creates a new ProxyClient whose output is sent to the given PrintWriter
     **/
    public ProxyClient (OutputStream o) {
        this(o, new SimplifiedClient());
    }

    public ProxyClient(OutputStream o, SimplifiedClient s)
    {
        sc = s;
	out=o;
    }


    /**
     * Main routine to wrap a Freenet request
     **/
    public FProxyDocument request(String uri) throws MalformedURLException, IOException, NoDataException
    {
//                Pair p=sc.get(uri);
//                Bucket file=(Bucket)p.first;
//                Bucket meta=(Bucket)p.last;
                Bucket file=new PipedBucket();
                FileBucket meta=new FileBucket();
                sc.getMetadata(uri, file, meta);
                InputStream min=meta.getInputStream();
                String mimeType=null;
                if(min!=null)
                {
                  FieldSet f=new FieldSet(new ReadInputStream(min));
                  mimeType=f.get("Content-Type");
                  meta.getFile().delete();
                }
                FProxyDocument doc=new FProxyDocument(mimeType, file.getInputStream());
                return doc;
    }


    /**
     * Main routine to wrap a Freenet insert
     **/
    public String insert(String uri, InputStream datastream,
			    String contentType)
	throws BindException, UnknownHostException, MalformedURLException,
	       BadAddressException, IOException, KeyException,
	       InsertFailedException, GracefulFailureException,
               CollisionException
    {

	// fill plaintext data bucket
	FileBucket plaintext = new FileBucket();
	FileBucket metaPlaintext = new FileBucket();
	OutputStream out = plaintext.getOutputStream();
	byte[] buffer = new byte[Core.bufferSize];
	for (int i = datastream.read(buffer); i != -1;
	     i = datastream.read(buffer)) {
	    out.write(buffer,0,i);
	}
	out.close();

	// make a metadata bucket, if necessary
	sc.getLogger().log(this, "Got content type: " + contentType,
			Logger.DEBUGGING);
	if (contentType != null) {
	    WriteOutputStream wo = new WriteOutputStream(metaPlaintext.getOutputStream());
	    FieldSet fs = new FieldSet();
	    fs.add("Content-Type", contentType);
	    fs.writeFields(wo);
	    wo.close();
	}

        String key = sc.put(uri, plaintext, metaPlaintext);

        plaintext.getFile().delete();
        metaPlaintext.getFile().delete();

        if(key==null)
          throw new InsertFailedException();
        else
        {
	    // succeeded, return the canonical key
	    return key;
	}
    }
}
