package Freenet.contrib.fproxy.filter;
import java.io.*;
import java.util.*;

/**
 * A simple implementation of a ContentFilter for the Freenet FProxy.
 *  It detects:
 *	- Pages with embedded code or objects
 *	- Pages with embedded external links
 *	- Pages with non-embedded external links (these are "warnings")
 *	- Documents with unknown mime types
 *
 * @author devrandom@hyper.to
 */

public class SimpleFilter implements ContentFilter
{
  private boolean debug = false;
  private boolean allowSecurityErrors = false;
  private boolean allowSecurityWarnings = false;

  public void setDebug(boolean debug) {
	this.debug = debug;
  }
  
  public void setAllowSecurityWarnings(boolean value) {
      allowSecurityWarnings = value;
  }

  public void setAllowSecurityErrors(boolean value) {
      allowSecurityErrors = value;
  }

  Hashtable passthroughTypes;

  public InputStream run(InputStream strm, String mimeType) throws IOException {
      if (passthroughTypes.get(mimeType) != null)
	  return strm;
      
      mimeType = mimeType.trim();
      // It better be HTML, or we junk it
      if (!allowSecurityErrors && !"text/html".equals(mimeType)) {
	  throw new FilterException("Unknown mime type " + mimeType,
				    "You have retrieved some content which is not recognised by FProxy, and so we "+
				    "don't know what your web browser might do with it.  It could be harmless, "+
				    "but it could make your web browser do something which would compromise your "+
				    "anonymity.", null);
      }
      
      Parser parser = new Parser(strm);
      String resultString = parser.parse();
      FilterAnalysis analysis = parser.getAnalysis();
      
      if (!allowSecurityErrors && analysis.isSecurityErrors()) {
	  throw new FilterException("Executable code or embedded external links in document",
				    "The document contains code which can be executed.  In the past this was "+
				    "used as a way to redirect you to a page which is updated at regular "+
				    "intervals, but could also compromise your anonymity.", analysis);
      }
      if (!allowSecurityWarnings && analysis.isSecurityWarnings()) {
	  throw new FilterException("External links in document",
				    "This page will load content from the world wide web.  This could be an "+
				    "error on the part of the page creator - or it could be used to compromise "+
				    "your anonymity.", analysis);
      }
      byte[] result = resultString.getBytes();
      return new ByteArrayInputStream(result);
  }

  public SimpleFilter(String passthroughMimeTypesString) {
      passthroughTypes = new Hashtable();
      StringTokenizer st = new StringTokenizer(passthroughMimeTypesString, ",");
      while (st.hasMoreTokens()) {
	  passthroughTypes.put(st.nextToken().trim(), "");
      }
  }
} 
