/*
 * Copyright (C) 1998 Mark Tumpfel and Uli Luckas
 * Modified by Theodore Hong
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * To reach the Authors you can send E-Mail to:
 *	Mark Tuempfel <marktop@cs.tu-berlin.de>
 *      Uli Luckas    <luckas@cs.tu-brelin.de>
 *
 */

package Freenet.contrib.fproxy.mumail.mime;
import java.io.*;


public class MIME_message_rfc822 extends MIME {
  MIME Body;
  mimeHeader MailHeader;

  public MIME_message_rfc822() {
    super();
  }

  public MIME_message_rfc822(InputStream in, PrintWriter pw) throws IOException {
    super(in, pw);
  }

  public MIME_message_rfc822(String[] mailLine) {
    super(mailLine);
  }

  public MIME_message_rfc822(String[] mailLine, int headerStart, int bodyStop) {
    super(mailLine, headerStart, bodyStop);
  }

  public MIME_message_rfc822(mimeHeader Header, String[] mailLine, int bodyStart, int bodyStop) {
    super(Header, mailLine, bodyStart, bodyStop);
  }

  void extractBody(String mailLine[], int bodyStart, int bodyStop) {
    MailHeader = new mimeHeader(mailLine, bodyStart, bodyStop);
    Body = constructMIME(MailHeader, mailLine, bodyStart + MailHeader.getLength() + 1, bodyStop); 
  }     

  public MIME getBody(){
    return Body;
  }
}
