/*
 * Copyright (C) 1998 Mark Tumpfel and Uli Luckas
 * Modified by Theodore Hong
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * To reach the Authors you can send E-Mail to:
 *	Mark Tuempfel <marktop@cs.tu-berlin.de>
 *      Uli Luckas    <luckas@cs.tu-brelin.de>
 *
 */

package Freenet.contrib.fproxy.mumail.mime;
import java.util.*;

public class MIME_multipart extends MIME {
  Vector Parts;

  public MIME_multipart() {
    super();
  }

  public MIME_multipart(String[] mailLine) {
    super(mailLine);
  }

  public MIME_multipart(String[] mailLine, int headerStart, int bodyStop) {
    super(mailLine, headerStart, bodyStop);
  }

  public MIME_multipart(mimeHeader Header, String[] mailLine, int bodyStart, int bodyStop) {
    super(Header, mailLine, bodyStart, bodyStop);
  }

  void extractBody(String[] mailLine, int bodyStart, int bodyStop) {
    int     i;
    int     j;
    boolean finalBoundaryFound = false;
    MIME    Part;                                       
    String  Boundary = Header.getContent_TypeParameter("boundary");

    Boundary = "--" + Boundary;

    i = bodyStart;
    while (i < bodyStop && !mailLine[i].startsWith(Boundary)) {
      i++;
    }

    j = ++i;
    Parts = new Vector();
    while (j < bodyStop && !finalBoundaryFound) {
      if (mailLine[j].startsWith(Boundary)) {
	Part = constructMIME(mailLine, i, j);
	Parts.addElement(Part);
	i = j + 1;
	finalBoundaryFound = mailLine[j].startsWith(Boundary + "--");
      }  else {
      }
      j++;
    }
  }

  public int getPartCount(){
    return Parts.size();
  }
  
  public MIME getPart(int i){
    if(i<0 || i>=getPartCount()){
      //IllegalArgumentException 
      return null;
    }
    else{
      return (MIME) Parts.elementAt(i);
    }
  }  
}
