/*
 * Copyright (C) 1998 Mark Tumpfel and Uli Luckas
 * Modified by Theodore Hong
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * To reach the Authors you can send E-Mail to:
 *	Mark Tuempfel <marktop@cs.tu-berlin.de>
 *      Uli Luckas    <luckas@cs.tu-brelin.de>
 *
 */

package Freenet.contrib.fproxy.mumail.mime;
import java.io.*;
import java.util.Hashtable;

public class MIME_text_plain extends MIMEtext {
  public MIME_text_plain() {
    super();
  }

  public MIME_text_plain(String[] mailLine) {
    super(mailLine);
  }

  public MIME_text_plain(String[] mailLine, int headerStart, int bodyStop) {
    super(mailLine, headerStart, bodyStop);
  }

  public MIME_text_plain(mimeHeader Header, String[] mailLine, int bodyStart, int bodyStop) {
    super(Header, mailLine, bodyStart, bodyStop);
  }

  protected String[] extractBodyLines(byte Buffer[]) {
    int i;
    String           currentLine;
    java.util.Vector lineVector = new java.util.Vector();
    BufferedReader   Reader;
    String[]         Line;
    String           ContentTypeHeader;
    String           Charset;
    String           Encoding;

    Charset = Header.getContent_TypeParameter("charset").toLowerCase();

    if(Charset.compareTo("us-ascii") == 0) {
      Charset = "iso-8859-1";
    }

    Encoding = getAliasName(Charset);
    if (Encoding == null) {
      Encoding = Charset;
    }

    // System.err.println("Using encoding '" + Encoding + "'.");
    
    try {
      Reader = new BufferedReader( new InputStreamReader(new ByteArrayInputStream(Buffer), Encoding));
    } catch (java.lang.Exception e1) {
      Reader = new BufferedReader( new InputStreamReader(new ByteArrayInputStream(Buffer)));
      // System.err.println("'" + Encoding + "' encoding unknown - using iso-8859-1");
    }

    try {
      while(null != (currentLine = Reader.readLine())) {
	lineVector.addElement(currentLine);
      }
    } catch (IOException e) {
      throw new RuntimeException("MIME_text_plain: unexpected error decoding buffer");
    }

    Line = new String[lineVector.size()];
    lineVector.copyInto(Line);
    return(Line);
  }

  protected static final Hashtable alias = new Hashtable();

    // All aliases should be upper case
  static {
      alias.put("DEFAULT",            "Default");
      alias.put("ISO-8859-1",         "8859_1");
      alias.put("ISO_8859_1",         "8859_1");
      alias.put("ISO 8859-1",         "8859_1");
      alias.put("ISO 8859_1",         "8859_1");
      alias.put("ISO_8859-1",         "8859_1");
      alias.put("ISO8859_1",          "8859_1");
      alias.put("ISO-IR-100",         "8859_1");
      alias.put("LATIN1",             "8859_1");
      alias.put("L1",                 "8859_1");
      alias.put("IBM819",             "8859_1");
      alias.put("CP819",              "8859_1");
      alias.put("CSISOLATIN1",        "8859_1");
      alias.put("ISO-8859-2",         "8859_2");
      alias.put("ISO-8859-3",         "8859_3");
      alias.put("ISO-8859-4",         "8859_4");
      alias.put("ISO-8859-5",         "8859_5");
      alias.put("ISO-8859-6",         "8859_6");
      alias.put("ISO-8859-7",         "8859_7");
      alias.put("ISO-8859-8",         "8859_8");
      alias.put("ISO-8859-9",         "8859_9");
      alias.put("ISO-2022-JP",        "EUC_JP");
      alias.put("EBCDIC",             "CP1046");
      alias.put("UTF-8",              "UTF8");
      alias.put("KOI8-R",             "KOI8_R");
        /* add more here */
  }
    
  protected String getAliasName(String charset) { return (String) alias.get(charset.toUpperCase()); }
}
