package Freenet.contrib.storeplot;

import java.awt.*;
import java.awt.color.*;
import java.awt.event.*;
import javax.swing.*;
import java.math.BigInteger;
import java.util.*;
import java.io.*;
import Freenet.FieldSet;
import Freenet.support.io.*;

public class PlotBar extends JComponent {

    public int[] points=new int[1024];

    public PlotBar() {
	setBackground(new Color(255,255,255));
	setSize(getPreferredSize());
    }

    public int getPlot(int slot) {
	return points[slot];
    }

    public void addPlot(int slot) {
	points[slot]++;
    }

    public void addPlot(BigInteger key) {
	int slot=key.shiftRight(174).intValue();
	points[slot]++;
    }
	
    public void paint(Graphics g) {
	g.setColor(Color.white);
	g.fillRect(0,0,1024,10);
	for (int i=0; i<points.length; i++) {
	    if (points[i]>0) {
		int c=Math.max(0, Math.min(255,255-(points[i]<<5)));
		g.setColor(new Color(c,c,c));
		g.drawLine(i,0,i,10);
	    }
	}
    }
	
    public Dimension getPreferredSize() {
	return new Dimension(1024,10);
    }

    public static PlotBar fromASR(String asrFile) throws IOException {
	PlotBar b=new PlotBar();
	BufferedReader rd=new BufferedReader(new FileReader(asrFile));

	rd.skip(10);
	while(true) {
	    String key=rd.readLine();
	    if (key==null) break;
	    b.addPlot(new BigInteger(key,16));
	}
	rd.close();

	return b;
    }

    public static void main(String[] args) throws Exception {
	Random r=new Random();
	Frame f=new Frame();
	final Label l=new Label("                    ",Label.CENTER);
	f.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
		    System.exit(1);
		}
	    });

	JPanel pc=new JPanel(new FlowLayout(FlowLayout.CENTER,
					    0,0));
	for (int i=0; i<args.length; i++) {
	    final PlotBar b=PlotBar.fromASR(args[i]);
	    b.addMouseListener(new MouseAdapter() {
		    public void mouseClicked(MouseEvent e) {
			StoreGraph g=new StoreGraph(b);
			final Frame gf=new Frame("Store graph");
			gf.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e2) {
				    gf.dispose();
				}
			    });
			gf.add(g);
			gf.pack();
			gf.show();
		    }
		});

	    b.addMouseMotionListener(new MouseMotionAdapter() {
		    protected PlotBar pb=b;
		    public void mouseMoved(MouseEvent e) {
			l.setText(Integer.toString(e.getX()<<2,16)+
				  ": "+pb.getPlot(e.getX()));
		    }
		});
	    pc.add(b);
	}
	pc.add(l);
	f.add(pc);
	f.setSize(1024,args.length*40);
	//	f.setSize(1024,args.length*10);
	f.show();
    }
}
    
